---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：281-スニペット編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL Mutationの詳細仕様**：GraphQL定義ファイルの直接確認が必要
  2. **Vue.jsコンポーネントの詳細実装**：フロントエンドコードの直接確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/snippets/edit.html.haml`（行1-11）
- E-02: `app/controllers/snippets_controller.rb`（行1-43）
- E-03: `app/controllers/concerns/snippets_actions.rb`（行1-93）
- E-04: `app/models/snippet.rb`（行1-393）
- E-05: `app/views/shared/snippets/_form.html.haml`（行1-3）
- E-06: `config/routes/snippets.rb`（行1-26）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行340）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`（行282）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは `/-/snippets/:id/edit` | E-06 | ○ |
| C-02 | コントローラーは snippets#edit | E-02 | ○ |
| C-03 | 編集権限は authorize_update_snippet! でチェック | E-02 (行13) | ○ |
| C-04 | タイトル最大長は255文字 | E-04 (行60) | ○ |
| C-05 | 説明の最大長は1MB | E-04 (行27, 63) | ○ |
| C-06 | ファイル名最大長は255文字 | E-04 (行61-62) | ○ |
| C-07 | contentは必須 | E-04 (行65) | ○ |
| C-08 | パンくずリストにSnippets表示 | E-01 (行1-3) | ○ |
| C-09 | ページタイトルは「Edit snippet」 | E-01 (行8-9) | ○ |
| C-10 | Monacoエディタを使用 | E-01 (行5-6) | ○ |
| C-11 | Vue.jsコンポーネントでフォーム実装 | E-05 | ○ |
| C-12 | 関連機能は「個人スニペット」(No.72) | E-07 | ○ |
| C-13 | 画面カテゴリは「スニペット」 | E-08 | ○ |
| C-14 | authorのみ編集可能 | E-02 (行13), E-03 | ○ |
| C-15 | 最大ファイル数は10ファイル | E-04 (行25) | ○ |
| C-16 | visibility_levelの値（0,10,20） | E-04 (行74-76) | ○ |
| C-17 | スパムチェック機能あり | E-04 (行289-294) | ○ |
| C-18 | contentサイズ制限は設定による | E-04 (行66) | ○ |
| C-19 | snippet_repositoriesテーブル更新 | E-04 (行51-52) | ○ |
| C-20 | updated_atは自動更新 | E-04 (Railsモデル標準) | ○ |
| C-21 | preview_markdownエンドポイントでプレビュー | E-06 (行10-11) | ○ |
| C-22 | rawアクションでファイル取得 | E-06 (行5-6) | ○ |
| C-23 | 404エラー時の挙動 | E-02 (before_action :snippet) | ○ |
| C-24 | GraphQL updateSnippet Mutationの詳細 | **根拠なし** | △ |
| C-25 | Snippets::UpdateServiceの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL Mutationの詳細仕様
  - 候補：`app/graphql/mutations/snippets/update.rb` / `app/graphql/types/snippet_type.rb`
- Vue.jsフロントエンドコンポーネントの詳細実装
  - 候補：`app/assets/javascripts/snippets/` ディレクトリ配下

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD操作で標準的な実装
- 1: 中リスク - GraphQL APIの仕様変更時に影響あり
- 0: 低リスク - 権限チェックは標準的なRails実装

## 6) レビュアーチェックリスト（最小）
- [ ] GraphQL Mutation `updateSnippet` の存在と仕様を確認
- [ ] Snippets::UpdateService のバリデーションロジックを確認
- [ ] フロントエンドのVue.jsコンポーネント実装を確認
- [ ] スパム検出機能のトリガー条件を確認
