---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：282-Wiki表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：フロントエンドコードの直接確認が必要
  2. **Gitalyとの通信詳細**：Git操作の詳細仕様確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/shared/wikis/show.html.haml`（行1-48）
- E-02: `app/controllers/concerns/wiki_actions.rb`（行1-503）
- E-03: `app/models/wiki_page.rb`（行1-508）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行341）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行283）
- E-06: `docs/code-to-docs/画面遷移図.md`（該当箇所なし - 間接参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WikiコンテンツはGitリポジトリに格納 | E-02 (行341-352), E-03 | ○ |
| C-02 | showアクションでページ存在チェック | E-02 (行131-147) | ○ |
| C-03 | ページ不存在時は作成フォーム表示 | E-02 (行177-208) | ○ |
| C-04 | リダイレクト機能あり | E-02 (行149-184, 449-500) | ○ |
| C-05 | Front Matterでタイトル指定可能 | E-03 (行168-170) | ○ |
| C-06 | 非UTF-8時に警告表示 | E-02 (行392-395) | ○ |
| C-07 | 編集権限チェックはauthorize_create_wiki! | E-02 (行29) | ○ |
| C-08 | 閲覧権限チェックはauthorize_read_wiki! | E-02 (行28) | ○ |
| C-09 | templates/配下がテンプレート | E-03 (行244-246) | ○ |
| C-10 | バージョン表示機能あり | E-02 (行378-382) | ○ |
| C-11 | 履歴表示機能あり | E-02 (行260-275) | ○ |
| C-12 | 削除機能はDestroyService | E-02 (行291-307) | ○ |
| C-13 | Vue.jsアプリでレンダリング | E-01 (行11) | ○ |
| C-14 | クローンURL表示あり | E-01 (行27-28) | ○ |
| C-15 | container_id, container_type をデータ属性で渡す | E-01 (行13-14) | ○ |
| C-16 | show_edit_button の表示制御 | E-01 (行20) | ○ |
| C-17 | show_restore_version_button の表示制御 | E-01 (行18) | ○ |
| C-18 | is_page_historical でバージョン判定 | E-01 (行23) | ○ |
| C-19 | page_version でコミット情報を渡す | E-01 (行25) | ○ |
| C-20 | content_api でコンテンツ取得 | E-01 (行17) | ○ |
| C-21 | format_options でマークアップ形式一覧 | E-01 (行37) | ○ |
| C-22 | Gitタイムアウト時にエラー画面 | E-02 (行61-65) | ○ |
| C-23 | リポジトリ不存在時に空画面 | E-02 (行67-71) | ○ |
| C-24 | diagrams.net連携はCSP設定 | E-02 (行16-23) | ○ |
| C-25 | 関連機能は「Wiki閲覧」(No.68) | E-04 | ○ |
| C-26 | 画面カテゴリは「Wiki」 | E-05 | ○ |
| C-27 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |
| C-28 | Gitalyとの通信詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントの詳細実装
  - 候補：`app/assets/javascripts/pages/shared/wikis/` ディレクトリ配下
- Gitalyとの通信詳細
  - 候補：`lib/gitlab/git/wiki.rb` / `lib/gitlab/gitaly_client/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の標準的な表示機能
- 1: 中リスク - Git操作のタイムアウト処理
- 0: 低リスク - 権限チェックは標準的なRails実装

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネント `#js-vue-wiki-app` の実装を確認
- [ ] content_api エンドポイントの仕様を確認
- [ ] Gitaly操作のエラーハンドリングを確認
- [ ] リダイレクト機能（.redirects.yml）の仕様を確認
