---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：283-Wiki編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsエディタコンポーネントの詳細実装**：フロントエンドコードの直接確認が必要
  2. **サービス層の詳細実装**：CreateService/UpdateServiceの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/shared/wikis/edit.html.haml`（行1-18）
- E-02: `app/controllers/concerns/wiki_actions.rb`（行1-503）
- E-03: `app/models/wiki_page.rb`（行1-508）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行342）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行284）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | editアクションでテンプレート一覧取得 | E-02 (行216-219) | ○ |
| C-02 | newアクションでランダムUUIDリダイレクト | E-02 (行74-83) | ○ |
| C-03 | createアクションでCreateService呼び出し | E-02 (行244-257) | ○ |
| C-04 | updateアクションでUpdateService呼び出し | E-02 (行222-240) | ○ |
| C-05 | 楽観的ロックでlast_commit_sha使用 | E-03 (行302-309) | ○ |
| C-06 | PageChangedError で競合検出 | E-03 (行8, 305-308) | ○ |
| C-07 | PageRenameError で重複検出 | E-03 (行9, 312-315) | ○ |
| C-08 | タイトル必須バリデーション | E-03 (行102) | ○ |
| C-09 | パス長バリデーション | E-03 (行103, 464-481) | ○ |
| C-10 | コンテンツサイズバリデーション | E-03 (行104, 484-492) | ○ |
| C-11 | 予約語バリデーション | E-03 (行105, 495-505) | ○ |
| C-12 | RESERVED_SLUGS の内容 | E-03 (行15-21) | ○ |
| C-13 | templates/ 配下がテンプレート | E-02 (行103-111) | ○ |
| C-14 | _sidebar でサイドバー作成 | E-02 (行315-327) | ○ |
| C-15 | handle_action_success でリダイレクト | E-02 (行315-327) | ○ |
| C-16 | 非UTF-8時にリダイレクト | E-02 (行49-55) | ○ |
| C-17 | authorize_create_wiki! で権限チェック | E-02 (行29) | ○ |
| C-18 | format_options でマークアップ形式一覧 | E-01 (行15) | ○ |
| C-19 | templates でテンプレート一覧 | E-01 (行16) | ○ |
| C-20 | page_info でページ情報JSON | E-01 (行11) | ○ |
| C-21 | is_page_template フラグ | E-01 (行12) | ○ |
| C-22 | page_persisted フラグ | E-01 (行13) | ○ |
| C-23 | wiki_url でWikiパス | E-01 (行14) | ○ |
| C-24 | error でエラー表示 | E-01 (行9) | ○ |
| C-25 | form_errors でバリデーションエラー表示 | E-01 (行6) | ○ |
| C-26 | 関連機能は「Wikiページ作成・編集」(No.69) | E-04 | ○ |
| C-27 | 画面カテゴリは「Wiki」 | E-05 | ○ |
| C-28 | Front Matterサイズ制限 | E-03 (行410) | ○ |
| C-29 | Vue.jsエディタコンポーネントの詳細 | **根拠なし** | △ |
| C-30 | サービス層の詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsエディタコンポーネントの詳細実装
  - 候補：`app/assets/javascripts/pages/shared/wikis/` ディレクトリ配下
- サービス層の詳細実装
  - 候補：`app/services/wiki_pages/create_service.rb` / `app/services/wiki_pages/update_service.rb`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 楽観的ロック機能の競合処理
- 1: 中リスク - Git操作のエラーハンドリング
- 0: 低リスク - 標準的なフォームバリデーション

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsエディタコンポーネント `#js-vue-wiki-edit-app` の実装を確認
- [ ] WikiPages::CreateService の実装を確認
- [ ] WikiPages::UpdateService の実装を確認
- [ ] 楽観的ロック（PageChangedError）のUI表示を確認
- [ ] Front Matterのサイズ制限とエラー処理を確認
