---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 29
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：284-検索結果

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：29 / 32、根拠なし：3
- 優先レビュー（高）
  1. **Vue.jsサイドバーコンポーネントの詳細**：フロントエンド実装の確認が必要
  2. **Elasticsearch/Zoekt連携の詳細**：高度な検索の実装確認が必要
  3. **検索結果レンダリングの詳細**：各スコープの表示実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/search/show.html.haml`（行1-37）
- E-02: `app/controllers/search_controller.rb`（行1-337）
- E-03: `app/services/search_service.rb`（行1-204）
- E-04: `app/views/search/_results.html.haml`（行1-4）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行343-345）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行285）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションで検索実行 | E-02 (行48-69) | ○ |
| C-02 | countアクションで件数取得 | E-02 (行71-97) | ○ |
| C-03 | autocompleteアクションあり | E-02 (行113-129) | ○ |
| C-04 | SearchServiceでファサードパターン | E-03 (行187-198) | ○ |
| C-05 | search_term_valid? でバリデーション | E-02 (行187-201) | ○ |
| C-06 | valid_query_length? で文字数チェック | E-03 (行54) | ○ |
| C-07 | valid_terms_count? で語数チェック | E-03 (行54) | ○ |
| C-08 | check_single_commit_result? でコミットリダイレクト | E-02 (行215-239) | ○ |
| C-09 | redact_unauthorized_results で権限フィルタ | E-03 (行142-165) | ○ |
| C-10 | DEFAULT_PER_PAGE = 20 | E-03 (行7) | ○ |
| C-11 | MAX_PER_PAGE = 200 | E-03 (行8) | ○ |
| C-12 | global_search? でグローバル検索判定 | E-03 (行40-42) | ○ |
| C-13 | level でproject/group/global判定 | E-03 (行90-99) | ○ |
| C-14 | global_search_enabled_for_scope? でスコープ有効チェック | E-03 (行101-116) | ○ |
| C-15 | count API に1分キャッシュ | E-02 (行93) | ○ |
| C-16 | autocomplete API に1分キャッシュ | E-02 (行126) | ○ |
| C-17 | タイムアウト時にrender_timeout | E-02 (行288-303) | ○ |
| C-18 | レート制限あり | E-02 (行25-27, 39) | ○ |
| C-19 | abuse_detected? で不正検出 | E-03 (行79-82) | ○ |
| C-20 | #js-search-topbar マウントポイント | E-01 (行22) | ○ |
| C-21 | #js-search-sidebar マウントポイント | E-01 (行24) | ○ |
| C-22 | navigation_json でスコープナビ | E-01 (行26) | ○ |
| C-23 | search_type データ属性 | E-01 (行27) | ○ |
| C-24 | advanced_search_available フラグ | E-01 (行28) | ○ |
| C-25 | zoekt_available フラグ | E-01 (行29) | ○ |
| C-26 | search_level データ属性 | E-01 (行30) | ○ |
| C-27 | 関連機能にグローバル検索(No.102) | E-05 | ○ |
| C-28 | 関連機能にプロジェクト内検索(No.103) | E-05 | ○ |
| C-29 | 関連機能に高度な検索(No.104) | E-05 | ○ |
| C-30 | Vue.jsサイドバーコンポーネントの詳細 | **根拠なし** | △ |
| C-31 | Elasticsearch/Zoekt連携の詳細 | **根拠なし** | △ |
| C-32 | 検索結果レンダリングの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsサイドバーコンポーネントの詳細
  - 候補：`app/assets/javascripts/search/` ディレクトリ配下
- Elasticsearch/Zoekt連携の詳細
  - 候補：`ee/app/services/search/` / `lib/gitlab/search/zoekt/`
- 検索結果レンダリングの詳細
  - 候補：`app/views/search/results/` ディレクトリ配下

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 検索クエリのバリデーション・サニタイズ
- 1: 中リスク - 権限フィルタリング（redact_unauthorized_results）
- 2: 高リスク - タイムアウト処理とユーザー体験
- 1: 中リスク - レート制限の閾値設定

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsサイドバーコンポーネント `#js-search-sidebar` の実装を確認
- [ ] 各検索スコープの結果表示テンプレートを確認
- [ ] Elasticsearch/Zoekt有効時の挙動を確認
- [ ] redact_unauthorized_results のログ出力を確認
- [ ] タイムアウト時のユーザー向けメッセージを確認
