---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：285-GitHubインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **OAuth連携Concernの詳細**：GithubOauth モジュールの確認が必要
  2. **Vue.jsコンポーネントの詳細**：Feature Flag有効時のUIの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/import/github/new.html.haml`（行1-66）
- E-02: `app/controllers/import/github_controller.rb`（行1-315）
- E-03: `config/routes/import.rb`（行19-29）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行346）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行286）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションで認証画面表示 | E-02 (行26-31) | ○ |
| C-02 | callbackアクションでOAuthコールバック | E-02 (行34-43) | ○ |
| C-03 | personal_access_tokenアクションでPAT保存 | E-02 (行45-48) | ○ |
| C-04 | github_import_configured? でOAuth設定チェック | E-02 (行27) | ○ |
| C-05 | logged_in_with_provider? でログイン状態チェック | E-02 (行27, 284-288) | ○ |
| C-06 | セッションにトークン保存 | E-02 (行40, 46) | ○ |
| C-07 | status_import_url へリダイレクト | E-02 (行41, 47) | ○ |
| C-08 | auth_state 検証 | E-02 (行36-38) | ○ |
| C-09 | provider_unauthorized でエラーハンドリング | E-02 (行236-242) | ○ |
| C-10 | provider_rate_limit でレート制限ハンドリング | E-02 (行245-250) | ○ |
| C-11 | provider_forbidden でスコープ不足ハンドリング | E-02 (行252-270) | ○ |
| C-12 | Feature Flag でVue.js分岐 | E-01 (行6) | ○ |
| C-13 | Vue.jsマウントポイント定義 | E-01 (行7-15) | ○ |
| C-14 | PAT入力フォーム | E-01 (行36-45) | ○ |
| C-15 | 必要スコープの説明 | E-01 (行46-59) | ○ |
| C-16 | OAuth認証ボタン | E-01 (行26-30) | ○ |
| C-17 | 設定未完了アラート | E-01 (行31-34) | ○ |
| C-18 | ci_cd_only パラメータ対応 | E-01 (行41-42) | ○ |
| C-19 | /import/github/new ルーティング | E-03 (行19) | ○ |
| C-20 | /import/github/personal_access_token ルーティング | E-03 (行20) | ○ |
| C-21 | /import/github/callback ルーティング | E-03 (行23) | ○ |
| C-22 | 関連機能はGitHubインポート(No.105) | E-04 | ○ |
| C-23 | OAuth連携Concernの詳細 | **根拠なし** | △ |
| C-24 | Vue.jsコンポーネントの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- OAuth連携Concernの詳細
  - 候補：`app/controllers/concerns/import/github_oauth.rb`
- Vue.jsコンポーネントの詳細
  - 候補：`app/assets/javascripts/import_entities/` ディレクトリ配下

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - OAuth認証のセキュリティ（state検証）
- 1: 中リスク - PATのセッション管理（暗号化）
- 0: 低リスク - レート制限のユーザー通知

## 6) レビュアーチェックリスト（最小）
- [ ] GithubOauth Concern の実装を確認
- [ ] Vue.jsコンポーネント `#js-vue-import-github-project-app` の実装を確認
- [ ] セッションへのトークン保存方法（暗号化）を確認
- [ ] OAuth state パラメータの検証ロジックを確認
