---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：286-GitHubインポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **Import::GithubServiceの詳細実装**：サービス層の詳細確認が必要
  2. **Vue.jsコンポーネントの詳細**：フロントエンドUIの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/import/github/status.html.haml`（行1-16）
- E-02: `app/views/import/_githubish_status.html.haml`（行1-30）
- E-03: `app/controllers/import/github_controller.rb`（行1-315）
- E-04: `config/routes/import.rb`（行19-29）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行347）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行287）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | statusアクションでHTML/JSON分岐 | E-03 (行50-67) | ○ |
| C-02 | createアクションでインポート実行 | E-03 (行72-79) | ○ |
| C-03 | realtime_changesで進捗取得 | E-03 (行82-86) | ○ |
| C-04 | cancelでキャンセル処理 | E-03 (行101-109) | ○ |
| C-05 | cancel_allで全キャンセル | E-03 (行111-126) | ○ |
| C-06 | countsでリポジトリ件数取得 | E-03 (行128-134) | ○ |
| C-07 | PAGE_LENGTH = 25 | E-03 (行24) | ○ |
| C-08 | 3秒ポーリング間隔 | E-03 (行83) | ○ |
| C-09 | client_repos_response でリポジトリ取得 | E-03 (行196-204) | ○ |
| C-10 | Import::GithubService で実行 | E-03 (行73) | ○ |
| C-11 | cancel_path をパーシャルに渡す | E-01 (行12) | ○ |
| C-12 | details_path をパーシャルに渡す | E-01 (行13) | ○ |
| C-13 | optional_stages をパーシャルに渡す | E-01 (行15) | ○ |
| C-14 | #import-projects-mount-element マウントポイント | E-02 (行16) | ○ |
| C-15 | repos_path データ属性 | E-02 (行19) | ○ |
| C-16 | jobs_path データ属性 | E-02 (行20) | ○ |
| C-17 | import_path データ属性 | E-02 (行23) | ○ |
| C-18 | default_target_namespace データ属性 | E-02 (行21) | ○ |
| C-19 | paginatable フラグ | E-02 (行28) | ○ |
| C-20 | /import/github/status ルーティング | E-04 (行21) | ○ |
| C-21 | /import/github/realtime_changes ルーティング | E-04 (行24) | ○ |
| C-22 | /import/github (POST) ルーティング | E-04 (行19) | ○ |
| C-23 | /import/github/cancel ルーティング | E-04 (行26) | ○ |
| C-24 | 関連機能はGitHubインポート(No.105) | E-05 | ○ |
| C-25 | Import::GithubServiceの詳細実装 | **根拠なし** | △ |
| C-26 | Vue.jsコンポーネントの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Import::GithubServiceの詳細実装
  - 候補：`app/services/import/github_service.rb`
- Vue.jsコンポーネントの詳細
  - 候補：`app/assets/javascripts/import_entities/` ディレクトリ配下

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - インポートジョブのエラーハンドリング
- 1: 中リスク - ポーリングのパフォーマンス影響
- 0: 低リスク - キャンセル処理の整合性

## 6) レビュアーチェックリスト（最小）
- [ ] Import::GithubService の実装を確認
- [ ] Vue.jsコンポーネント `#import-projects-mount-element` の実装を確認
- [ ] realtime_changes のポーリング間隔とサーバー負荷を確認
- [ ] cancel処理のジョブ停止ロジックを確認
- [ ] optional_stages の設定内容を確認
