---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：287-GitHubインポート詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **owner_access権限の詳細確認**：authorize_owner_access! の対象確認が必要
  2. **インポート完了判定の詳細**：import_finished? の実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/import/github/details.html.haml`（行1-4）
- E-02: `app/controllers/import/github_controller.rb`（行70, 88-99, 161-167）
- E-03: `config/routes/import.rb`（行22, 25）
- E-04: `app/assets/javascripts/import/details/index.js`（行1-23）
- E-05: `app/assets/javascripts/import/details/components/import_details_app.vue`（行1-44）
- E-06: `app/assets/javascripts/import/details/components/import_details_table.vue`（行1-197）
- E-07: `app/assets/javascripts/import/details/api.js`（行1-11）
- E-08: `app/serializers/import/github_failure_serializer.rb`（行1-9）
- E-09: `app/serializers/import/github_failure_entity.rb`（行1-178）
- E-10: `app/models/import_failure.rb`（行1-25）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行348）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | detailsアクションは空メソッド | E-02 (行70) | ○ |
| C-02 | failuresアクションで失敗項目取得 | E-02 (行88-99) | ○ |
| C-03 | import_finished? で完了チェック | E-02 (行89) | ○ |
| C-04 | 未完了時400エラー | E-02 (行90-93) | ○ |
| C-05 | with_external_identifiers スコープ使用 | E-02 (行95), E-10 (行13) | ○ |
| C-06 | GithubFailureSerializer でページネーション | E-02 (行96), E-08 (行5) | ○ |
| C-07 | /import/github/details ルーティング | E-03 (行22) | ○ |
| C-08 | /import/github/failures ルーティング | E-03 (行25) | ○ |
| C-09 | .js-import-details マウントポイント | E-01 (行4), E-04 (行5) | ○ |
| C-10 | failures_path データ属性 | E-01 (行4), E-04 (行11) | ○ |
| C-11 | failuresPath を provide | E-04 (行16-18) | ○ |
| C-12 | ImportDetailsApp コンポーネント | E-05 (行5-6) | ○ |
| C-13 | フィールド定義（type, title, provider_url, details） | E-05 (行9-29) | ○ |
| C-14 | DEFAULT_PAGE_SIZE = 20 | E-06 (行13) | ○ |
| C-15 | LocalStorageキー gl-import-details-page-size | E-05 (行31) | ○ |
| C-16 | loadImportFailures で初期読み込み | E-06 (行94-95, 118-140) | ○ |
| C-17 | setPage/setPageSize メソッド | E-06 (行98-107) | ○ |
| C-18 | fetchImportFailures API呼び出し | E-06 (行112), E-07 (行3-10) | ○ |
| C-19 | GlTable コンポーネント使用 | E-06 (行2, 151) | ○ |
| C-20 | PaginationBar コンポーネント使用 | E-06 (行8, 188-195) | ○ |
| C-21 | GithubFailureEntity の type expose | E-09 (行5-7) | ○ |
| C-22 | GithubFailureEntity の title expose | E-09 (行9-11, 51-98) | ○ |
| C-23 | GithubFailureEntity の provider_url expose | E-09 (行13-15, 100-164) | ○ |
| C-24 | GithubFailureEntity の details expose | E-09 (行17-46) | ○ |
| C-25 | import_failures モデル | E-10 (行1-25) | ○ |
| C-26 | 関連機能はGitHubインポート(No.105) | E-11 | ○ |
| C-27 | owner_access権限の詳細確認 | **根拠なし** | △ |
| C-28 | インポート完了判定の詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- owner_access権限の詳細確認
  - 候補：`app/policies/project_policy.rb`
- インポート完了判定の詳細実装
  - 候補：`app/models/project.rb` または `app/models/import_state.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 参照のみの画面で更新処理なし
- 1: 中リスク - 権限チェック（owner_access）の適切性
- 0: 低リスク - ページネーションの実装

## 6) レビュアーチェックリスト（最小）
- [ ] authorize_owner_access! の対象アクションを確認（details/failuresが含まれているか）
- [ ] import_finished? メソッドの実装を確認
- [ ] 大量の失敗項目がある場合のパフォーマンスを確認
- [ ] external_identifiers の各タイプに対するURL生成を確認
- [ ] lfs_object, note_attachment でURL空文字の動作を確認
