---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：288-GitLabインポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **GitLabインポート専用コントローラーの確認**：専用コントローラーの有無確認が必要
  2. **Vue.jsコンポーネントの詳細確認**：プロバイダ固有の処理確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/import/gitlab/status.html.haml`（行1-6）
- E-02: `app/views/import/_githubish_status.html.haml`（行1-29）
- E-03: `config/routes/import.rb`（行72-77）
- E-04: `app/controllers/import/bulk_imports_controller.rb`（行1-237）
- E-05: `app/assets/javascripts/import_entities/import_projects/index.js`（行1-86）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行349）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`（行289）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page_title「GitLab.com import」 | E-01 (行1) | ○ |
| C-02 | ハートアイコン表示 | E-01 (行3) | ○ |
| C-03 | 「Import projects from GitLab.com」見出し | E-01 (行4) | ○ |
| C-04 | _githubish_status パーシャル使用 | E-01 (行6) | ○ |
| C-05 | provider: 'gitlab' 指定 | E-01 (行6) | ○ |
| C-06 | filterable: false 指定 | E-01 (行6) | ○ |
| C-07 | default_namespace パラメータ | E-01 (行6) | ○ |
| C-08 | #import-projects-mount-element マウントポイント | E-02 (行16) | ○ |
| C-09 | repos_path データ属性 | E-02 (行19) | ○ |
| C-10 | jobs_path データ属性 | E-02 (行20) | ○ |
| C-11 | import_path データ属性 | E-02 (行23) | ○ |
| C-12 | default_target_namespace データ属性 | E-02 (行21) | ○ |
| C-13 | /import/bulk_imports/status ルーティング | E-03 (行74) | ○ |
| C-14 | /import/bulk_imports/realtime_changes ルーティング | E-03 (行75) | ○ |
| C-15 | POLLING_INTERVAL = 3_000 | E-04 (行14) | ○ |
| C-16 | bulk_imports status アクション | E-04 (行28-51) | ○ |
| C-17 | bulk_imports realtime_changes アクション | E-04 (行80-84) | ○ |
| C-18 | initStoreFromElement 関数 | E-05 (行13-40) | ○ |
| C-19 | initPropsFromElement 関数 | E-05 (行42-50) | ○ |
| C-20 | 関連機能はGitLabインポート(No.106) | E-06 | ○ |
| C-21 | GitLabインポート専用コントローラー | **根拠なし** | △ |
| C-22 | Vue.jsプロバイダ固有処理の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GitLabインポート専用コントローラー
  - 候補：`app/controllers/import/gitlab_controller.rb`（存在しない可能性あり）
  - 注記：GitLab.comインポートは bulk_imports を使用している可能性
- Vue.jsプロバイダ固有処理の詳細
  - 候補：`app/assets/javascripts/import_entities/import_projects/` ディレクトリ配下

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 認証トークンの管理（セッション保存）
- 1: 中リスク - ポーリングのパフォーマンス影響
- 0: 低リスク - フィルタリング無効の妥当性

## 6) レビュアーチェックリスト（最小）
- [ ] GitLabインポート専用コントローラーの有無を確認（bulk_importsとの関係）
- [ ] `_githubish_status` パーシャルでの `gitlab` プロバイダ処理を確認
- [ ] Vue.jsコンポーネントでの `gitlab` プロバイダ固有処理を確認
- [ ] ポーリング間隔（3秒）のサーバー負荷を確認
- [ ] フィルタリング無効の理由を確認
