---
generated_at: 2026-01-22 11:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：290-Giteaインポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **Gitea APIクライアントの詳細**：LegacyGithubImport::Clientの確認が必要
  2. **Vue.jsコンポーネントの詳細**：Gitea固有処理の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/import/gitea/status.html.haml`（行1-7）
- E-02: `app/views/import/_githubish_status.html.haml`（行1-29）
- E-03: `app/controllers/import/gitea_controller.rb`（行1-112）
- E-04: `app/controllers/import/github_controller.rb`（行1-315）
- E-05: `config/routes/import.rb`（行31-35）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行351）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`（行291）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | page_title「Gitea import」 | E-01 (行1) | ○ |
| C-02 | Giteaアイコン表示 | E-01 (行4) | ○ |
| C-03 | 「Import projects from Gitea」見出し | E-01 (行5) | ○ |
| C-04 | _githubish_status パーシャル使用 | E-01 (行7) | ○ |
| C-05 | provider: 'gitea' 指定 | E-01 (行7) | ○ |
| C-06 | default_namespace パラメータ | E-01 (行7) | ○ |
| C-07 | statusアクションでHTML/JSON分岐 | E-03 (行19-35) | ○ |
| C-08 | JSON応答で3種類のリスト返却 | E-03 (行22-24) | ○ |
| C-09 | client_repos でGitea APIから取得 | E-03 (行75-78) | ○ |
| C-10 | LegacyGithubImport::Client 使用 | E-03 (行81) | ○ |
| C-11 | api_version: 'v1' 指定 | E-03 (行89) | ○ |
| C-12 | GithubController を継承 | E-03 (行3) | ○ |
| C-13 | レート制限（gitea_import） | E-03 (行6-7) | ○ |
| C-14 | #import-projects-mount-element マウントポイント | E-02 (行16) | ○ |
| C-15 | repos_path データ属性 | E-02 (行19) | ○ |
| C-16 | jobs_path データ属性 | E-02 (行20) | ○ |
| C-17 | import_path データ属性 | E-02 (行23) | ○ |
| C-18 | default_target_namespace データ属性 | E-02 (行21) | ○ |
| C-19 | /import/gitea/status ルーティング | E-05 (行33) | ○ |
| C-20 | /import/gitea/realtime_changes ルーティング | E-05 (行34) | ○ |
| C-21 | /import/gitea (POST) ルーティング | E-05 (行31) | ○ |
| C-22 | 関連機能はGitHubインポート(No.105) | E-06 | ○ |
| C-23 | Gitea APIクライアントの詳細 | **根拠なし** | △ |
| C-24 | Vue.jsコンポーネントの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Gitea APIクライアントの詳細
  - 候補：`lib/gitlab/legacy_github_import/client.rb`
- Vue.jsコンポーネントの詳細
  - 候補：`app/assets/javascripts/import_entities/import_projects/` ディレクトリ配下

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Gitea API v1 との互換性
- 1: 中リスク - ポーリングのパフォーマンス影響
- 0: 低リスク - レート制限の閾値設定

## 6) レビュアーチェックリスト（最小）
- [ ] LegacyGithubImport::Client の Gitea 対応を確認
- [ ] Gitea API v1 のエンドポイント互換性を確認
- [ ] Vue.jsコンポーネント `#import-projects-mount-element` のGitea対応を確認
- [ ] realtime_changes のポーリング間隔を確認
- [ ] gitea_import レート制限の閾値を確認
