---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：291-Bitbucket Serverインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御の詳細**：コントローラーでの権限チェック実装の直接確認が必要
  2. **Feature Flagの正式名称**：Feature Flag名の確認が必要
  3. **エラーメッセージID体系**：メッセージIDは設計上の命名であり、コード上の対応確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/bitbucket_server_controller.rb`
- E-02: `app/views/import/bitbucket_server/new.html.haml`
- E-03: `config/routes/import.rb`
- E-04: `app/assets/javascripts/import/bitbucket_server/import_from_bitbucket_server_app.vue`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `app/controllers/import/base_controller.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はBitbucket Serverからのインポート開始画面である | E-02, E-05 | ○ |
| C-02 | URL、ユーザー名、トークンの3項目を入力する | E-01 (行57-60), E-02 (行20-28) | ○ |
| C-03 | ルーティングは`/import/bitbucket_server/new`である | E-03 (行43-48) | ○ |
| C-04 | configureアクションでセッションに認証情報を保存する | E-01 (行57-63) | ○ |
| C-05 | Feature Flag `new_project_creation_form`で UI が切り替わる | E-02 (行5) | ○ |
| C-06 | Vueコンポーネントが存在する | E-04 | ○ |
| C-07 | Vueコンポーネントでバリデーションを実行する | E-04 (行39-47) | ○ |
| C-08 | 接続エラー時にエラーメッセージを表示する | E-01 (行175-189) | ○ |
| C-09 | セッションキーは3つ定義されている | E-01 (行141-151) | ○ |
| C-10 | credentialsメソッドで認証情報を取得する | E-01 (行159-165) | ○ |
| C-11 | before_actionでインポート機能有効性をチェックする | E-01 (行9) | ○ |
| C-12 | 認証情報がない場合はnew画面へリダイレクトする | E-01 (行129-135) | ○ |
| C-13 | BaseControllerを継承している | E-01 (行3), E-07 | ○ |
| C-14 | 画面機能マッピングでBitbucketインポートに関連付けられている | E-06 (行352-354) | ○ |
| C-15 | インポート先ネームスペースを指定できる | E-01 (行62), E-02 (行8) | ○ |
| C-16 | エラー時にセッションデータをクリアする | E-01 (行153-157, 177) | ○ |
| C-17 | 画面Noは291である | E-05 (行292) | ○ |
| C-18 | 権限チェックはネームスペースへのインポート権限で行う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について、コントローラー内での権限チェック実装の詳細が確認できなかった
  - 候補：`app/controllers/import/bitbucket_server_controller.rb` / `app/controllers/import/base_controller.rb` / ポリシークラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証情報の入力・保存処理は明確に実装されている
- 0: 低リスク - ルーティングとコントローラーの対応は確認済み
- 1: 中リスク - 権限チェックの実装詳細は追加確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] Feature Flag `new_project_creation_form` の有効・無効両方の動作を確認
- [ ] Bitbucket Server URLの形式バリデーションが適切か確認
- [ ] セッションに保存された認証情報の有効期限・セキュリティを確認
- [ ] 権限チェックの実装詳細を確認（ネームスペースへのインポート権限）
