---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：292-Bitbucket Serverインポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **ポーリング間隔の確認**：3秒間隔は基底クラスに定義されているが、実際の動作確認が必要
  2. **データベース更新の詳細**：ProjectCreatorの実装詳細確認が必要
  3. **互換性チェックのロジック**：valid?メソッドの実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/bitbucket_server_controller.rb`
- E-02: `app/views/import/bitbucket_server/status.html.haml`
- E-03: `config/routes/import.rb`
- E-04: `app/views/import/_githubish_status.html.haml`
- E-05: `app/services/import/bitbucket_server_service.rb`
- E-06: `app/controllers/import/base_controller.rb`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はBitbucket Serverのインポート状態画面である | E-02, E-07 | ○ |
| C-02 | statusアクションでリポジトリ一覧を取得する | E-01 (行66-70), E-06 (行17-32) | ○ |
| C-03 | createアクションでインポートを実行する | E-01 (行32-54) | ○ |
| C-04 | _githubish_statusパーシャルを使用する | E-02 (行8-12) | ○ |
| C-05 | paginatable: trueでページネーション対応 | E-02 (行10) | ○ |
| C-06 | リポジトリはvalid?メソッドで互換性チェックされる | E-01 (行74-82) | ○ |
| C-07 | BitbucketServerServiceでインポート処理を実行 | E-01 (行44-48), E-05 | ○ |
| C-08 | リポジトリが見つからない場合422エラーを返す | E-01 (行35-42) | ○ |
| C-09 | セッションに認証情報がない場合リダイレクトする | E-01 (行129-135) | ○ |
| C-10 | realtime_changesでポーリング更新する | E-03 (行47), E-06 (行34-37) | ○ |
| C-11 | ポーリング間隔は3秒 | E-06 (行35) | ○ |
| C-12 | プロジェクトキーとリポジトリスラグのバリデーションを行う | E-01 (行114-127) | ○ |
| C-13 | VALID_BITBUCKET_PROJECT_CHARSで文字種を制限 | E-01 (行27-28) | ○ |
| C-14 | 接続エラー時にセッションをクリアする | E-01 (行175-189) | ○ |
| C-15 | reconfigure_pathをextra_dataとして渡す | E-02 (行12) | ○ |
| C-16 | サービスでURLブロックチェックを行う | E-05 (行8-10, 86-95) | ○ |
| C-17 | サービスで権限チェックを行う | E-05 (行12-14) | ○ |
| C-18 | import_typeは'bitbucket_server'である | E-05, E-01 (行86-87) | ○ |
| C-19 | プロジェクト作成成功時はProjectSerializerでレスポンス | E-01 (行51) | ○ |
| C-20 | インポート処理はバックグラウンドジョブで実行される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20について、ProjectCreator内でのバックグラウンドジョブ起動の詳細が確認できなかった
  - 候補：`lib/gitlab/bitbucket_server_import/project_creator.rb` / `app/workers/` 配下のワーカー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとサービスの処理フローは明確
- 0: 低リスク - バリデーションロジックは正規表現で定義済み
- 1: 中リスク - バックグラウンドジョブの実装詳細は追加確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] ページネーションの動作確認（大量リポジトリ時）
- [ ] リアルタイム更新のポーリング動作確認
- [ ] インポート失敗時のエラーハンドリング確認
- [ ] 互換性チェック（valid?メソッド）の判定基準確認
- [ ] バックグラウンドジョブの実装確認
