---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：293-Bitbucketインポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 通常レビューで確認推奨
  2. OAuthトークン自動更新の動作確認
  3. ページネーション（カーソルベース）の動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/bitbucket_controller.rb`
- E-02: `app/views/import/bitbucket/status.html.haml`
- E-03: `config/routes/import.rb`
- E-04: `app/views/import/_githubish_status.html.haml`
- E-05: `app/controllers/import/base_controller.rb`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はBitbucket Cloudのインポート状態画面である | E-02, E-06 | ○ |
| C-02 | OAuth2認証でBitbucketと連携する | E-01 (行143-149, 175-182) | ○ |
| C-03 | callbackアクションでOAuthトークンを取得する | E-01 (行16-35) | ○ |
| C-04 | セッションにtoken、expires_at、refresh_tokenを保存 | E-01 (行28-31) | ○ |
| C-05 | stateパラメータでCSRF対策を行う | E-01 (行17-21) | ○ |
| C-06 | statusアクションでHTML/JSON両対応 | E-01 (行37-54) | ○ |
| C-07 | _githubish_statusパーシャルを使用する | E-02 (行9) | ○ |
| C-08 | paginatable: trueでページネーション対応 | E-02 (行9) | ○ |
| C-09 | createアクションでインポートを実行する | E-01 (行56-99) | ○ |
| C-10 | リポジトリIDは___でオーナー/リポジトリを区切る | E-01 (行60) | ○ |
| C-11 | find_or_create_namespaceでネームスペースを処理 | E-01 (行67) | ○ |
| C-12 | 権限チェック後にプロジェクトを作成する | E-01 (行77-88) | ○ |
| C-13 | 権限不足時は422エラーを返す | E-01 (行96-97) | ○ |
| C-14 | OAuth2::Errorをrescueしてリダイレクトする | E-01 (行11-12, 184-188) | ○ |
| C-15 | Bitbucket::Error::Unauthorizedもrescueする | E-01 (行12) | ○ |
| C-16 | トークン更新後にセッションを更新する | E-01 (行80) | ○ |
| C-17 | PAGE_LENGTHは25件 | E-01 (行14) | ○ |
| C-18 | カーソルベースのページネーションを使用 | E-01 (行159) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - OAuth認証フローは標準的な実装
- 0: 低リスク - コントローラーの処理は明確
- 0: 低リスク - エラーハンドリングも適切

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth認証フローの動作確認（認可→コールバック→リダイレクト）
- [ ] トークン期限切れ時のrefresh処理確認
- [ ] カーソルベースページネーションの動作確認
- [ ] Bitbucket API側の権限とGitLab側で表示されるリポジトリの一致確認
