---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：294-Manifestインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 通常レビューで確認推奨
  2. Manifestファイル形式の詳細仕様確認
  3. XMLパーサーのセキュリティ確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/manifest_controller.rb`
- E-02: `app/views/import/manifest/new.html.haml`
- E-03: `app/views/import/manifest/_form.html.haml`
- E-04: `config/routes/import.rb`
- E-05: `app/assets/javascripts/import/manifest/import_manifest_file_app.vue`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はManifestファイルインポート開始画面である | E-02, E-06 | ○ |
| C-02 | newアクションで初期画面を表示する | E-01 (行13) | ○ |
| C-03 | uploadアクションでManifestを解析する | E-01 (行22-60) | ○ |
| C-04 | ルーティングは/import/manifest/newである | E-04 (行86-90) | ○ |
| C-05 | Feature Flag new_project_creation_formでUIが切り替わる | E-02 (行6) | ○ |
| C-06 | Vueコンポーネントが存在する | E-05 | ○ |
| C-07 | 従来フォームは_form.html.hamlパーシャル | E-02 (行18), E-03 | ○ |
| C-08 | ファイルサイズ上限は1MB | E-01 (行6) | ○ |
| C-09 | check_file_sizeでサイズチェックを行う | E-01 (行11, 131-147) | ○ |
| C-10 | グループへのインポート権限をチェックする | E-01 (行25-27) | ○ |
| C-11 | Manifestはvalid?で検証する | E-01 (行32) | ○ |
| C-12 | 成功時はstatus画面へリダイレクトする | E-01 (行41) | ○ |
| C-13 | VueコンポーネントでFormDataでPOSTする | E-05 (行84-89) | ○ |
| C-14 | Vueコンポーネントは.xmlファイルのみ許可 | E-05 (行105) | ○ |
| C-15 | グループ選択コンポーネントを使用する | E-05 (行117-127), E-03 (行6-12) | ○ |
| C-16 | manifest_import_metadataでメタデータを保存 | E-01 (行33, 115-117) | ○ |
| C-17 | インポート機能無効時は404を返す | E-01 (行123-125) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイルアップロードとバリデーションは明確に実装されている
- 0: 低リスク - Feature Flagによる分岐は確認済み
- 1: 中リスク - XMLパーサーのセキュリティ（XXE攻撃対策など）の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 1MBサイズ制限の動作確認
- [ ] XMLファイル以外のアップロード時のエラーハンドリング確認
- [ ] Manifest形式の詳細仕様（repo tool形式）との互換性確認
- [ ] XMLパーサーのセキュリティ（XXE攻撃対策）確認
- [ ] グループ選択の権限チェック動作確認
