---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：295-Manifestインポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 通常レビューで確認推奨
  2. グループ削除時のリダイレクト動作確認
  3. 大量リポジトリ時のパフォーマンス確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/manifest_controller.rb`
- E-02: `app/views/import/manifest/status.html.haml`
- E-03: `config/routes/import.rb`
- E-04: `app/views/import/_githubish_status.html.haml`
- E-05: `app/controllers/import/base_controller.rb`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はManifestインポート状態画面である | E-02, E-06 | ○ |
| C-02 | statusアクションでリポジトリ一覧を取得する | E-01 (行15-20) | ○ |
| C-03 | createアクションでインポートを実行する | E-01 (行62-74) | ○ |
| C-04 | _githubish_statusパーシャルを使用する | E-02 (行6) | ○ |
| C-05 | importable_reposはメタデータのrepositoriesを返す | E-01 (行78-81) | ○ |
| C-06 | incompatible_reposは常に空配列 | E-01 (行83-86) | ○ |
| C-07 | extra_representation_optsでgroup_full_pathを渡す | E-01 (行98-101) | ○ |
| C-08 | ensure_import_varsでメタデータの存在をチェック | E-01 (行10, 105-107) | ○ |
| C-09 | グループがない場合はnew画面へリダイレクト | E-01 (行106) | ○ |
| C-10 | グループはメタデータのgroup_idから取得 | E-01 (行110-113) | ○ |
| C-11 | ProjectCreatorでプロジェクトを作成 | E-01 (行67) | ○ |
| C-12 | import_typeは'manifest'である | E-01 (行88-91) | ○ |
| C-13 | provider_urlはnilを返す | E-01 (行93-96) | ○ |
| C-14 | repo_idで配列からリポジトリを検索 | E-01 (行63-65) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーの処理は明確
- 0: 低リスク - メタデータ管理は一貫している
- 1: 中リスク - 大量リポジトリ（数百件）時のパフォーマンス確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] メタデータがセッションにない場合のリダイレクト動作確認
- [ ] グループ削除時のエラーハンドリング確認
- [ ] 大量リポジトリ時のパフォーマンス確認
- [ ] リアルタイム更新（ポーリング）の動作確認
