---
generated_at: 2026-01-22 12:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：296-Fogbugzインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 通常レビューで確認推奨
  2. URLブロックチェックの設定確認
  3. レート制限の設定値確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/fogbugz_controller.rb`
- E-02: `app/views/import/fogbugz/new.html.haml`
- E-03: `config/routes/import.rb`
- E-04: `app/assets/javascripts/import/fogbugz/import_from_fogbugz_app.vue`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はFogBugzインポート開始画面である | E-02, E-05 | ○ |
| C-02 | newアクションで初期画面を表示する | E-01 (行16) | ○ |
| C-03 | callbackアクションで認証を実行する | E-01 (行18-30) | ○ |
| C-04 | ルーティングは/import/fogbugz/newである | E-03 (行50-57) | ○ |
| C-05 | Feature Flag new_project_creation_formでUIが切り替わる | E-02 (行5) | ○ |
| C-06 | Vueコンポーネントが存在する | E-04 | ○ |
| C-07 | URL、email、passwordの3項目を入力する | E-01 (行116-118), E-02 (行21-31) | ○ |
| C-08 | セッションにトークンとURIを保存する | E-01 (行26-27) | ○ |
| C-09 | 認証成功後はユーザーマッピング画面へリダイレクト | E-01 (行29) | ○ |
| C-10 | FogBugzImport::Clientでトークンを取得する | E-01 (行20, 26) | ○ |
| C-11 | 接続エラー時はエラーメッセージを表示 | E-01 (行22-24) | ○ |
| C-12 | AuthenticationErrorをrescueする | E-01 (行14, 112-114) | ○ |
| C-13 | verify_blocked_uriでURLブロックチェックを行う | E-01 (行12, 128-141) | ○ |
| C-14 | レート制限を適用する（fogbugz_import） | E-01 (行9) | ○ |
| C-15 | アイコンはbugを使用する | E-02 (行13) | ○ |
| C-16 | 認証成功後にユーザーマッピング画面へ遷移 | E-01 (行29), E-03 (行55-56) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証フローは明確に実装されている
- 0: 低リスク - URLブロックチェックは標準的なセキュリティ機能
- 1: 中リスク - FogBugz APIの仕様変更時の互換性確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] URLブロックチェックの動作確認（ローカルネットワーク制限）
- [ ] レート制限の設定値と動作確認
- [ ] 認証エラー時のエラーメッセージ確認
- [ ] FogBugz APIトークン取得の仕組み確認
