---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：297-Fogbugzユーザーマッピング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 通常レビューで確認推奨
  2. GitLabユーザー選択コンポーネントの動作確認
  3. マッピングスキップ時の動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/fogbugz_controller.rb`
- E-02: `app/views/import/fogbugz/new_user_map.html.haml`
- E-03: `config/routes/import.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はFogBugzユーザーマッピング設定画面である | E-02, E-04 | ○ |
| C-02 | new_user_mapアクションで画面を表示する | E-01 (行32) | ○ |
| C-03 | create_user_mapアクションでマッピングを保存する | E-01 (行34-48) | ○ |
| C-04 | ルーティングは/import/fogbugz/user_mapである | E-03 (行55-56) | ○ |
| C-05 | ユーザー名は必須（空不可） | E-01 (行37) | ○ |
| C-06 | 名前が空の場合はエラーメッセージを表示 | E-01 (行38-40) | ○ |
| C-07 | セッションにfogbugz_user_mapを保存する | E-01 (行42) | ○ |
| C-08 | 保存成功後はstatus画面へリダイレクト | E-01 (行46) | ○ |
| C-09 | user_mapはclient.user_mapとセッションをマージ | E-01 (行101-109) | ○ |
| C-10 | user_map_paramsでusers配列を許可 | E-01 (行120-122) | ○ |
| C-11 | before_actionでuser_mapを設定 | E-01 (行11) | ○ |
| C-12 | ユーザーテーブルで@user_mapをイテレート | E-02 (行34-40) | ○ |
| C-13 | .js-gitlab-userでGitLabユーザー選択を初期化 | E-02 (行40) | ○ |
| C-14 | アイコンはbugを使用 | E-02 (行7) | ○ |
| C-15 | 成功メッセージをflash[:notice]で表示 | E-01 (行44) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バリデーションは明確に実装されている
- 0: 低リスク - セッション保存は標準的な実装
- 1: 中リスク - GitLabユーザー選択コンポーネントの実装詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ユーザー名必須チェックの動作確認
- [ ] GitLabユーザー選択コンポーネントの動作確認
- [ ] マッピングスキップ時（status画面からの直接アクセス）の動作確認
- [ ] 大量ユーザー時のパフォーマンス確認
