---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：298-Fogbugzインポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 通常レビューで確認推奨
  2. ユーザーマッピングのフォールバック動作確認
  3. FogBugzインポートのケース（Issue）取り込み動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/fogbugz_controller.rb`
- E-02: `app/views/import/fogbugz/status.html.haml`
- E-03: `config/routes/import.rb`
- E-04: `app/views/import/_githubish_status.html.haml`
- E-05: `app/services/import/fogbugz_service.rb`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はFogBugzインポート状態画面である | E-02, E-06 | ○ |
| C-02 | statusアクションでclient.valid?をチェックする | E-01 (行50-51) | ○ |
| C-03 | 無効な場合はnew画面へリダイレクトする | E-01 (行51) | ○ |
| C-04 | createアクションでインポートを実行する | E-01 (行56-71) | ○ |
| C-05 | FogbugzServiceでインポート処理を行う | E-01 (行64), E-05 | ○ |
| C-06 | umapにユーザーマッピングを渡す | E-01 (行60) | ○ |
| C-07 | セッションにumapがない場合はclient.user_mapをフォールバック | E-01 (行60) | ○ |
| C-08 | _githubish_statusパーシャルを使用する | E-02 (行11) | ○ |
| C-09 | filterable: falseでフィルタリング無効 | E-02 (行11) | ○ |
| C-10 | importable_reposはclient.reposを返す | E-01 (行75-78) | ○ |
| C-11 | incompatible_reposは常に空配列 | E-01 (行80-83) | ○ |
| C-12 | ユーザーマップリンクを表示する | E-02 (行8-9) | ○ |
| C-13 | provider_urlはsession[:fogbugz_uri]を返す | E-01 (行91-93) | ○ |
| C-14 | サービスでURLブロックチェックを行う | E-05 (行10-11, 86-95) | ○ |
| C-15 | サービスで権限チェックを行う | E-05 (行13-19) | ○ |
| C-16 | import_typeは'fogbugz'（サービスで設定） | E-05 (行85-86) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとサービスの処理は明確
- 0: 低リスク - ユーザーマッピングのフォールバックロジックは単純
- 1: 中リスク - FogBugzケース（Issue）インポートの詳細実装確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ユーザーマッピングなしでのインポート動作確認
- [ ] ユーザーマッピングフォールバック動作確認
- [ ] FogBugzケース（Issue）のインポート内容確認
- [ ] インポートエラー時のエラーメッセージ確認
