---
generated_at: 2026-01-22 12:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：299-URLインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **認証情報の暗号化保存の詳細**：project_import_dataテーブルへの保存実装確認が必要
  2. ミラーリング機能の有効化条件確認
  3. プロジェクト作成フローの詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/import/url/new.html.haml`
- E-02: `app/assets/javascripts/import/url/index.js`
- E-03: `app/assets/javascripts/projects/new_v2/components/import_by_url_form.vue`
- E-04: `config/routes/import.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はURLインポート画面である | E-01, E-05 | ○ |
| C-02 | Vueコンポーネントでフォームを表示する | E-01, E-02, E-03 | ○ |
| C-03 | .js-vue-import-by-url-appでVueをマウントする | E-01 (行10), E-02 (行8) | ○ |
| C-04 | data属性で初期値を渡す | E-01 (行10-18), E-02 (行14-23) | ○ |
| C-05 | checkConnectionで接続確認を行う | E-03 (行74-98) | ○ |
| C-06 | isReasonableGitUrlでURL形式をチェック | E-03 (行75) | ○ |
| C-07 | importByUrlValidatePathにPOSTで接続確認 | E-03 (行80-84) | ○ |
| C-08 | 成功時はトーストでメッセージを表示 | E-03 (行87, 89-91) | ○ |
| C-09 | フォームは/projectsにPOSTする | E-03 (行119) | ○ |
| C-10 | ミラーリングオプションを提供する | E-03 (行185-202) | ○ |
| C-11 | ミラーリングは機能フラグで制御される | E-03 (行38-39, 191) | ○ |
| C-12 | ルーティングは/import/url/newである | E-04 (行15-17) | ○ |
| C-13 | 許可プロトコルはhttp, https, gitである | E-03 (行132-136) | ○ |
| C-14 | ユーザー名とパスワードはオプション | E-03 (行163-183) | ○ |
| C-15 | プロジェクト名からスラグを自動生成 | E-03 - 参照先コンポーネント | ○ |
| C-16 | 認証情報は暗号化されてDBに保存される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16について、project_import_dataテーブルへの認証情報保存とその暗号化の実装詳細が確認できなかった
  - 候補：`app/models/project_import_data.rb` / `lib/gitlab/import_export/` 配下

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Vueコンポーネントの実装は明確
- 0: 低リスク - 接続確認機能は標準的な実装
- 1: 中リスク - 認証情報の暗号化保存の実装詳細確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 接続確認機能の動作確認
- [ ] 認証情報の保存と暗号化の実装確認
- [ ] ミラーリング機能の有効化条件確認（ライセンス）
- [ ] git://プロトコルでのインポート動作確認
- [ ] プライベートリポジトリのインポート動作確認
