---
generated_at: 2026-01-22 11:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-パスワード変更画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/devise/passwords/edit.html.haml` - パスワード変更画面ビューテンプレート
- E-02: `app/controllers/passwords_controller.rb` - パスワードコントローラー（1-94行目）
- E-03: `app/models/user.rb` - ユーザーモデル
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（8行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（4行目）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（58-59行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/users/password/edit` でパスワード変更画面にアクセス | E-02 (Devise::PasswordsController継承) | ○ |
| C-02 | リセットトークンが隠しフィールドとして埋め込まれる | E-01 (5行目 hidden_field) | ○ |
| C-03 | 新しいパスワード入力が必須 | E-01 (8行目 required: true) | ○ |
| C-04 | パスワード確認入力が必須 | E-01 (12行目 required: true) | ○ |
| C-05 | トークン期限切れ時にリダイレクト | E-02 (32-35行目) | ○ |
| C-06 | password_automatically_setがfalseに更新される | E-02 (43行目) | ○ |
| C-07 | password_expires_atがNULLに更新される | E-02 (44行目) | ○ |
| C-08 | 弱いパスワード設定試行が記録される | E-02 (48行目 track_weak_password_error) | ○ |
| C-09 | 確認メール再送リンクが表示される | E-01 (18-19行目) | ○ |
| C-10 | Sign inリンクが表示される | E-01 (20行目 _sign_in_link) | ○ |
| C-11 | 関連機能No.78が正しくマッピングされている | E-04 (8行目) | ○ |
| C-12 | 画面遷移（ログイン画面への遷移）が正しい | E-06 (58-59行目) | ○ |
| C-13 | PUT /users/password でパスワード更新処理が実行される | E-01 (2行目 method: :put) | ○ |
| C-14 | パスワード複雑性検証クラスが適用される | E-01 (8行目 js-password-complexity-validation) | ○ |
| C-15 | autocomplete="new-password"が設定される | E-01 (8行目, 12行目) | ○ |
| C-16 | パスワード要件リストが表示される（EE） | E-01 (9行目 render_if_exists) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] パスワード複雑性要件がビジネス要件と一致しているか確認
- [ ] リセットトークンの有効期限設定を確認
- [ ] EE版のパスワード要件リスト機能の有無を確認
