---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：30-ファイルツリー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsファイルブラウザの詳細**：フロントエンドコンポーネントの確認が必要
  2. **GraphQLクエリの詳細実装**：GraphQLスキーマとリゾルバの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/projects/tree/show.html.haml`
- E-02: `app/views/projects/_files.html.haml`
- E-03: `app/views/projects/_tree_content.html.haml`
- E-04: `app/controllers/projects/tree_controller.rb`
- E-05: `config/routes/repository.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションの処理 | E-04 (29-48行目) | ○ |
| C-02 | require_non_empty_project | E-04 (13行目) | ○ |
| C-03 | assign_ref_vars | E-04 (14行目) | ○ |
| C-04 | set_is_ambiguous_ref | E-04 (15行目) | ○ |
| C-05 | authorize_read_code! | E-04 (17行目) | ○ |
| C-06 | コミット存在チェック | E-04 (30行目) | ○ |
| C-07 | require_auth?判定 | E-04 (32-37行目, 63-66行目) | ○ |
| C-08 | tree.entriesでの判定 | E-04 (41行目) | ○ |
| C-09 | blobへのリダイレクト | E-04 (42-43行目) | ○ |
| C-10 | パス不在時リダイレクト | E-04 (44-45行目) | ○ |
| C-11 | create_dirアクション | E-04 (50-59行目) | ○ |
| C-12 | Files::CreateDirService | E-04 (53行目) | ○ |
| C-13 | フィーチャーフラグのプッシュ | E-04 (20-24行目) | ○ |
| C-14 | GraphQLスタートアップクエリ | E-01 (4-6行目) | ○ |
| C-15 | repository_file_tree_browser フラグ | E-01 (8行目), E-02 (5行目, 14行目) | ○ |
| C-16 | filesパーシャルのrender | E-01 (17行目) | ○ |
| C-17 | tree_contentパーシャルのrender | E-02 (19行目, 22行目) | ○ |
| C-18 | Vue.jsマウントポイント（js-tree-list） | E-03 (19行目) | ○ |
| C-19 | 最終コミット情報表示 | E-03 (14行目) | ○ |
| C-20 | URL /tree/*id | E-05 (86行目) | ○ |
| C-21 | Vue.jsファイルブラウザの詳細 | **根拠なし** | △ |
| C-22 | GraphQLクエリの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsファイルブラウザコンポーネント
  - 候補：`app/assets/javascripts/repository/` / `app/assets/javascripts/pages/projects/tree/`
- GraphQLクエリとリゾルバ
  - 候補：`app/graphql/resolvers/` / `app/graphql/types/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラの基本処理
- 0: 低リスク - ビューのパーシャル構造
- 0: 低リスク - ルーティング
- 1: 中リスク - Vue.jsフロントエンドの詳細動作

## 6) レビュアーチェックリスト（最小）
- [ ] ExtractsPath concernのref/path抽出ロジックを確認
- [ ] 曖昧なref名の処理（同名ブランチ・タグ）を確認
- [ ] Vue.jsファイルブラウザコンポーネントの動作を確認
- [ ] GraphQLクエリの実行タイミングと内容を確認
- [ ] repository_file_tree_browser フィーチャーフラグの影響範囲を確認
