---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：301-一括インポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細仕様**：フロントエンドコードが未確認
  2. **エラーメッセージの完全性**：全エラーケースの網羅性が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/import/bulk_imports_controller.rb` - コントローラー実装
- E-02: `app/views/import/bulk_imports/status.html.haml` - ビューテンプレート
- E-03: `app/models/bulk_import.rb` - モデル定義
- E-04: `config/routes/import.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的はDirect Transferによるインポート | E-02 (行4) | ○ |
| C-02 | URLパスは`/import/bulk_imports/status` | E-04 (行74) | ○ |
| C-03 | ポーリング間隔は3秒 | E-01 (行14) | ○ |
| C-04 | Owner権限を持つグループのみ表示 | E-01 (行119) | ○ |
| C-05 | セッションにURL/Tokenを保存 | E-01 (行18-20, 165-170) | ○ |
| C-06 | BulkImportsControllerが制御 | E-01 | ○ |
| C-07 | statusアクションがHTMLとJSONを処理 | E-01 (行28-51) | ○ |
| C-08 | createアクションでインポート作成 | E-01 (行60-78) | ○ |
| C-09 | realtime_changesでポーリング応答 | E-01 (行80-83) | ○ |
| C-10 | BulkImportモデルにstate_machineあり | E-03 (行28-68) | ○ |
| C-11 | 状態はcreated/started/finished/timeout/failed/canceled | E-03 (行29-34) | ○ |
| C-12 | ソース最小バージョンは14 | E-03 (行9) | ○ |
| C-13 | URLブロック時にセッションクリア | E-01 (行182-186) | ○ |
| C-14 | レート制限時に429返却 | E-01 (行61) | ○ |
| C-15 | Bulk Import無効時に404 | E-01 (行160-162) | ○ |
| C-16 | bulk_importsテーブルへINSERT | E-03 (行13-17) | ○ |
| C-17 | bulk_import_entitiesテーブルへINSERT | E-03 (行17) | ○ |
| C-18 | プロジェクト移行は14.4以上 | E-03 (行10) | ○ |
| C-19 | namespace_idパラメータでインポート先指定 | E-01 (行43-46) | ○ |
| C-20 | 関連機能Noは110 | E-06 (行362) | ○ |
| C-21 | 履歴画面への遷移パスあり | E-02 (行13) | ○ |
| C-22 | data属性でVue.jsに設定渡し | E-02 (行7-16) | ○ |
| C-23 | Vue.jsフロントエンド実装の詳細 | **根拠なし** | △ |
| C-24 | 全エラーメッセージの網羅性 | **根拠不足** | △ |
| C-25 | BulkImports::CreateService使用 | E-01 (行70-72) | ○ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネント（`app/assets/javascripts/import_entities/`配下）が未読み込み
  - 候補：`import_groups_app.vue` / `bulk_import_*` コンポーネント
- i18nファイルからのメッセージ定義完全性

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - フロントエンド実装の詳細は別途確認が必要
- 0: 低リスク - バックエンド実装は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsフロントエンドの動作確認
- [ ] 実際のインポートフローの画面確認
- [ ] エラーメッセージの多言語対応確認
- [ ] セッション管理のセキュリティ確認
