---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：302-一括インポート履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：フロントエンドコードが未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/import/bulk_imports_controller.rb` - コントローラー実装
- E-02: `app/views/import/bulk_imports/history.html.haml` - ビューテンプレート
- E-03: `app/models/bulk_import.rb` - モデル定義
- E-04: `config/routes/import.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的はインポート履歴表示 | E-02 (行6) | ○ |
| C-02 | URLパスは`/import/bulk_imports/history` | E-04 (行76) | ○ |
| C-03 | 特定インポートの詳細パスは`/import/bulk_imports/:id/history` | E-04 (行81) | ○ |
| C-04 | 失敗詳細パスは`/import/bulk_imports/:id/history/:entity_id/failures` | E-04 (行82) | ○ |
| C-05 | historyアクションは空実装 | E-01 (行54) | ○ |
| C-06 | failuresアクションでエンティティ取得 | E-01 (行56-58) | ○ |
| C-07 | bulk_importはbefore_actionで取得 | E-01 (行9, 88-92) | ○ |
| C-08 | PendingReassignmentAlertPresenterでアラート制御 | E-02 (行10-11) | ○ |
| C-09 | アラート表示条件はshow_alert?メソッド | E-02 (行11) | ○ |
| C-10 | Learn moreリンクがヘルプページへ遷移 | E-02 (行16) | ○ |
| C-11 | Vue.jsマウントポイントはimport-history-mount-element | E-02 (行19) | ○ |
| C-12 | details_pathがdata属性で渡される | E-02 (行19) | ○ |
| C-13 | realtime_changes_pathがdata属性で渡される | E-02 (行19) | ○ |
| C-14 | namespaces_with_unassigned_placeholdersメソッド存在 | E-03 (行119-128) | ○ |
| C-15 | Import::SourceUser.for_namespaceスコープ使用 | E-03 (行124) | ○ |
| C-16 | ポーリング間隔は3秒 | E-01 (行14) | ○ |
| C-17 | 関連機能Noは110 | E-06 (行363) | ○ |
| C-18 | パンくずは@bulk_importの有無で切り替え | E-02 (行3-5) | ○ |
| C-19 | ページタイトルはMigration history | E-02 (行6) | ○ |
| C-20 | 参照専用画面でDB更新なし | E-01 (行54-58) | ○ |
| C-21 | ログインユーザー自身のインポートのみ表示 | E-01 (行230-232) | ○ |
| C-22 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネント（`app/assets/javascripts/import_entities/`配下）の詳細実装
  - 候補：`import_history_app.vue` / 関連コンポーネント
- PendingReassignmentAlertPresenterの実装詳細

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド実装は十分な根拠あり
- 1: 中リスク - フロントエンド実装の詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsフロントエンドの動作確認
- [ ] プレースホルダー再割り当てアラートの表示条件確認
- [ ] 失敗詳細画面の情報表示確認
- [ ] ポーリングによる状態更新の動作確認
