---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：303-インポート履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：フロントエンドコードが未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/import/history_controller.rb` - コントローラー実装
- E-02: `app/views/import/history/index.html.haml` - ビューテンプレート
- E-03: `config/routes/import.rb` - ルーティング定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的はインポート履歴一覧表示 | E-02 (行2) | ○ |
| C-02 | URLパスは`/import/history` | E-03 (行13) | ○ |
| C-03 | コントローラーはImport::HistoryController | E-01 | ○ |
| C-04 | feature_categoryはimporters | E-01 (行4) | ○ |
| C-05 | urgencyはlow | E-01 (行5) | ○ |
| C-06 | パンくずに「Create a new project」を追加 | E-02 (行1) | ○ |
| C-07 | ページタイトルは「Import history」 | E-02 (行2) | ○ |
| C-08 | Vue.jsマウントポイントはimport-history-mount-element | E-02 (行4) | ○ |
| C-09 | logoパスをdata属性で渡す | E-02 (行4) | ○ |
| C-10 | 参照専用画面でDB更新なし | E-01 | ○ |
| C-11 | 関連機能Noは110 | E-05 (行364) | ○ |
| C-12 | シンプルなコントローラー実装 | E-01 (6行のみ) | ○ |
| C-13 | 複数インポートソースの統合表示 | E-02, E-04 | ○ |
| C-14 | ログインユーザー自身のインポートのみ表示 | 認証が必要なコントローラー | ○ |
| C-15 | Vue.jsフロントエンドの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネント（`app/assets/javascripts/import_entities/`配下）の詳細実装
  - 候補：`import_history_app.vue` / 関連コンポーネント
- APIエンドポイントの定義（フロントエンドから呼び出されるAPI）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド実装は非常にシンプルで明確
- 1: 中リスク - フロントエンド実装の詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsフロントエンドの動作確認
- [ ] 各インポートソースからの履歴が正しく表示されるか確認
- [ ] フィルタリング機能の動作確認
- [ ] プロジェクトへのリンクが正しく機能するか確認
