---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：304-ソースユーザー確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **メール通知テンプレートの詳細**：メール送信部分が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/import/source_users_controller.rb` - コントローラー実装
- E-02: `app/views/import/source_users/show.html.haml` - ビューテンプレート
- E-03: `app/models/import/source_user.rb` - モデル定義
- E-04: `config/routes/import.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的は再割り当て確認 | E-02 (行1, 17-18) | ○ |
| C-02 | URLパスに名前空間IDとトークンが含まれる | E-04 (行93-95) | ○ |
| C-03 | showアクションで確認画面表示 | E-01 (行36) | ○ |
| C-04 | acceptアクションで承認処理 | E-01 (行10-21) | ○ |
| C-05 | declineアクションで拒否処理 | E-01 (行23-34) | ○ |
| C-06 | check_source_user_valid!でアクセス制御 | E-01 (行5, 40-44) | ○ |
| C-07 | awaiting_approval状態の確認 | E-01 (行41) | ○ |
| C-08 | current_user_matches_invite?で対象ユーザー確認 | E-01 (行41, 47-49) | ○ |
| C-09 | source_userの検索方法 | E-01 (行51-60) | ○ |
| C-10 | AcceptReassignmentService使用 | E-01 (行11-13) | ○ |
| C-11 | RejectReassignmentService使用 | E-01 (行24-26) | ○ |
| C-12 | バナー表示でフラッシュメッセージ | E-01 (行16, 29, 63-71) | ○ |
| C-13 | ソースユーザー情報の表示 | E-02 (行3-12) | ○ |
| C-14 | Pajamas::CardComponentでUI構築 | E-02 (行15) | ○ |
| C-15 | 承認ボタンはvariant: :danger | E-02 (行51) | ○ |
| C-16 | 承認ボタンのhref構築 | E-02 (行52) | ○ |
| C-17 | 拒否ボタンの実装 | E-02 (行55) | ○ |
| C-18 | ヘルプリンクの存在 | E-02 (行30) | ○ |
| C-19 | 状態遷移（state_machine）の定義 | E-03 (行64-117) | ○ |
| C-20 | awaiting_approvalからreassignment_in_progressへの遷移 | E-03 (行102-104) | ○ |
| C-21 | awaiting_approvalからrejectedへの遷移 | E-03 (行106-108) | ○ |
| C-22 | reassignment_tokenは32文字 | E-03 (行28) | ○ |
| C-23 | トークンはawaiting_approval状態でのみ存在 | E-03 (行27-28) | ○ |
| C-24 | before_transition awaiting_approval: anyでトークンクリア | E-03 (行74-76) | ○ |
| C-25 | 関連機能Noは110 | E-06 (行365) | ○ |
| C-26 | 警告メッセージの表示 | E-02 (行45-47) | ○ |
| C-27 | Import details / Reassignment detailsセクション | E-02 (行31-44) | ○ |
| C-28 | メール通知テンプレートの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 再割り当て要求時のメール通知テンプレート
  - 候補：`app/views/notify/`配下のメールテンプレート
- AcceptReassignmentService / RejectReassignmentServiceの詳細実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビュー・モデルは十分な根拠あり
- 0: 低リスク - 状態遷移ロジックは明確
- 1: 中リスク - サービス層の詳細実装は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 再割り当て承認フローの動作確認
- [ ] 再割り当て拒否フローの動作確認
- [ ] トークン無効時のエラーハンドリング確認
- [ ] メール通知内容の確認
- [ ] セキュリティ観点での確認（トークン推測攻撃対策）
