---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：305-招待確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **AcceptInviteServiceの詳細実装**：サービス層の詳細が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/invites_controller.rb` - コントローラー実装
- E-02: `app/views/invites/show.html.haml` - ビューテンプレート
- E-03: `app/views/invites/decline.html.haml` - 辞退画面テンプレート
- E-04: `app/models/member.rb` - モデル定義
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的は招待確認 | E-02 (行1-2) | ○ |
| C-02 | URLパスは`/-/invites/:id` | E-05 (行227) | ○ |
| C-03 | showアクションで確認画面表示 | E-01 (行19-21) | ○ |
| C-04 | acceptアクションで承諾処理 | E-01 (行30-38) | ○ |
| C-05 | declineアクションで辞退処理 | E-01 (行40-58) | ○ |
| C-06 | 認証はshowのみ必須 | E-01 (行7, 11) | ○ |
| C-07 | memberはbefore_actionで取得 | E-01 (行8, 75-79) | ○ |
| C-08 | invite_detailsでProject/Group判定 | E-01 (行132-149) | ○ |
| C-09 | skip_invitation_prompt?の条件 | E-01 (行62-64) | ○ |
| C-10 | current_user_matches_invite?の実装 | E-01 (行66-68) | ○ |
| C-11 | member?の実装 | E-01 (行70-73) | ○ |
| C-12 | AcceptInviteService使用 | E-01 (行31) | ○ |
| C-13 | decline_invite!メソッド使用 | E-01 (行41) | ○ |
| C-14 | 辞退時のリダイレクト条件分岐 | E-01 (行42-51) | ○ |
| C-15 | ミニマルレイアウトの使用条件 | E-01 (行42) | ○ |
| C-16 | 招待情報の表示（招待者、ソース、ロール） | E-02 (行13-17) | ○ |
| C-17 | 既存メンバーの場合の表示 | E-02 (行5-9) | ○ |
| C-18 | メール不一致時の表示 | E-02 (行25-32) | ○ |
| C-19 | 承諾ボタンの実装 | E-02 (行20) | ○ |
| C-20 | 辞退ボタンの実装 | E-02 (行22) | ○ |
| C-21 | トラッキングイベントの実装 | E-01 (行87-91) | ○ |
| C-22 | 未ログイン時のリダイレクト | E-01 (行93-103) | ○ |
| C-23 | セッションへの招待情報保存 | E-01 (行106-110) | ○ |
| C-24 | サインアップ可否の判定 | E-01 (行121-122) | ○ |
| C-25 | 関連機能Noは86 | E-07 (行366) | ○ |
| C-26 | ページタイトルはInvitation | E-02 (行1) | ○ |
| C-27 | 辞退画面の実装 | E-03 | ○ |
| C-28 | 辞退成功メッセージ | E-01 (行52-54) | ○ |
| C-29 | 辞退失敗メッセージ | E-01 (行56) | ○ |
| C-30 | AcceptInviteServiceの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AcceptInviteServiceの詳細実装
  - 候補：`app/services/members/accept_invite_service.rb`
- 招待メールテンプレートの詳細

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューは十分な根拠あり
- 0: 低リスク - 条件分岐ロジックは明確
- 1: 中リスク - サービス層の詳細実装は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 招待承諾フローの動作確認
- [ ] 招待辞退フローの動作確認
- [ ] メール不一致時の表示確認
- [ ] 既存メンバー時の表示確認
- [ ] 未ログイン状態でのアクセス時の動作確認
- [ ] トラッキングイベントの発火確認
