---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：306-招待辞退

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/invites_controller.rb` - コントローラー実装
- E-02: `app/views/invites/decline.html.haml` - ビューテンプレート
- E-03: `config/routes.rb` - ルーティング定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的は招待辞退完了表示 | E-02 (行1) | ○ |
| C-02 | URLパスは`/-/invites/:id/decline` | E-03 (行230) | ○ |
| C-03 | ミニマルレイアウト使用 | E-01 (行42) | ○ |
| C-04 | 表示条件：未ログイン | E-01 (行42) | ○ |
| C-05 | 表示条件：invite_to_unknown_user? | E-01 (行42) | ○ |
| C-06 | 表示条件：created_by存在 | E-01 (行42) | ○ |
| C-07 | ページタイトルは「Invitation declined」 | E-02 (行1) | ○ |
| C-08 | 成功アイコン（check-circle, size: 48） | E-02 (行4) | ○ |
| C-09 | 成功タイトルの表示 | E-02 (行5) | ○ |
| C-10 | 招待者への通知案内 | E-02 (行6-7) | ○ |
| C-11 | sanitize_nameでサニタイズ | E-02 (行7) | ○ |
| C-12 | member.created_byで招待者取得 | E-02 (行7) | ○ |
| C-13 | ウィンドウを閉じる案内 | E-02 (行8-9) | ○ |
| C-14 | 関連機能Noは86 | E-05 (行367) | ○ |
| C-15 | ログイン済みはダッシュボードへ | E-01 (行44-47) | ○ |
| C-16 | 条件不一致はログイン画面へ | E-01 (行48-49) | ○ |
| C-17 | decline_invite!メソッド呼び出し | E-01 (行41) | ○ |
| C-18 | CSSクラスでレスポンシブ対応 | E-02 (行3) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな完了画面であり、すべての実装が確認できる
- 0: 低リスク - 条件分岐ロジックも明確

## 6) レビュアーチェックリスト（最小）
- [ ] ミニマルレイアウトの表示確認
- [ ] 招待者名のサニタイズが正しく機能しているか確認
- [ ] 未ログイン状態での動作確認
- [ ] レスポンシブデザインの確認
