---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：307-クラスター一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsフロントエンドの詳細実装**：フロントエンドコードが未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/clusters/clusters_controller.rb` - コントローラー実装
- E-02: `app/views/clusters/clusters/index.html.haml` - ビューテンプレート
- E-03: `app/models/clusters/cluster.rb` - モデル定義
- E-04: `config/routes.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的はKubernetesクラスター一覧表示 | E-02 (行3) | ○ |
| C-02 | URLパスは`/-/clusters` | E-04 (行280) | ○ |
| C-03 | indexアクションで一覧表示 | E-01 (行17-31) | ○ |
| C-04 | HTML/JSON両対応 | E-01 (行20-30) | ○ |
| C-05 | ポーリング間隔は10秒 | E-01 (行15) | ○ |
| C-06 | authorize_read_cluster!で権限確認 | E-01 (行8) | ○ |
| C-07 | ensure_feature_enabled!で機能有効確認 | E-01 (行11, 141-142) | ○ |
| C-08 | cluster_listメソッドでクラスター取得 | E-01 (行145-161) | ○ |
| C-09 | ClusterAncestorsFinder使用 | E-01 (行148) | ○ |
| C-10 | has_ancestor_clusters判定 | E-01 (行151) | ○ |
| C-11 | Kaminariでページネーション | E-01 (行161) | ○ |
| C-12 | 1ページ20件 | E-01 (行161) | ○ |
| C-13 | ClusterSerializerでJSON変換 | E-01 (行24-27) | ○ |
| C-14 | render_gcp_signup_offerの呼び出し | E-02 (行5) | ○ |
| C-15 | js_clusters_list_dataでdata属性設定 | E-02 (行8) | ○ |
| C-16 | cluster_typeの種別 | E-03 (行75-79) | ○ |
| C-17 | provider_typeの種別 | E-03 (行85-89) | ○ |
| C-18 | status_nameメソッド | E-03 (行169-174) | ○ |
| C-19 | 証明書ベースクラスター無効時404 | E-01 (行141-142) | ○ |
| C-20 | 関連機能Noは60 | E-06 (行368) | ○ |
| C-21 | ページタイトルはKubernetes Clusters | E-02 (行3) | ○ |
| C-22 | パンくずの設定 | E-02 (行2) | ○ |
| C-23 | clustersスタイルの適用 | E-02 (行1) | ○ |
| C-24 | Polling設定 | E-01 (行23) | ○ |
| C-25 | Vue.jsフロントエンドの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネント（`app/assets/javascripts/clusters/`配下）の詳細実装
  - 候補：`clusters_bundle.js` / 関連コンポーネント
- ClusterAncestorsFinderの詳細実装
- GCP Signup Offerの表示条件

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド実装は十分な根拠あり
- 1: 中リスク - フロントエンド実装の詳細は別途確認が必要
- 0: 低リスク - 証明書ベースクラスターは非推奨であることを認識

## 6) レビュアーチェックリスト（最小）
- [ ] クラスター一覧の表示確認
- [ ] ポーリングによる状態更新の動作確認
- [ ] ページネーションの動作確認
- [ ] 祖先クラスターの表示確認
- [ ] 証明書ベースクラスター無効時の動作確認
