---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：308-クラスター詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **パーシャルテンプレートの詳細**：各タブのパーシャル内容が未確認
  2. **EE機能（Environments）の詳細**：EE専用機能が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/clusters/clusters_controller.rb` - コントローラー実装
- E-02: `app/views/clusters/clusters/show.html.haml` - ビューテンプレート
- E-03: `app/models/clusters/cluster.rb` - モデル定義
- E-04: `config/routes.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的はクラスター詳細表示・編集 | E-02 (行3) | ○ |
| C-02 | URLパスは`/-/clusters/:id` | E-04 (行280) | ○ |
| C-03 | showアクションで詳細表示 | E-01 (行6) | ○ |
| C-04 | updateアクションで設定更新 | E-01 (行47-67) | ○ |
| C-05 | destroyアクションで削除 | E-01 (行70-77) | ○ |
| C-06 | cluster_statusでJSON状態返却 | E-01 (行35-45) | ○ |
| C-07 | migrateアクションで移行開始 | E-01 (行98-113) | ○ |
| C-08 | clear_cacheアクションでキャッシュクリア | E-01 (行92-96) | ○ |
| C-09 | ポーリング間隔は10秒 | E-01 (行15) | ○ |
| C-10 | Clusters::UpdateService使用 | E-01 (行48-50) | ○ |
| C-11 | Clusters::DestroyService使用 | E-01 (行71-73) | ○ |
| C-12 | Clusters::Migration::CreateService使用 | E-01 (行99-104) | ○ |
| C-13 | update_paramsでユーザー提供判定 | E-01 (行177-200) | ○ |
| C-14 | data属性でstatus_path設定 | E-02 (行6-7) | ○ |
| C-15 | タブナビゲーション実装 | E-02 (行32-36) | ○ |
| C-16 | cluster_type_labelでバッジ表示 | E-02 (行26) | ○ |
| C-17 | cluster_created?で作成完了確認 | E-02 (行30) | ○ |
| C-18 | has_rbac_enabled?でRBAC確認 | E-02 (行10) | ○ |
| C-19 | provided_by_user?の判定 | E-03 (行90) | ○ |
| C-20 | status_nameメソッド | E-03 (行169-174) | ○ |
| C-21 | delete_cached_resources!メソッド | E-03 (行288-290) | ○ |
| C-22 | 関連機能Noは60 | E-06 (行369) | ○ |
| C-23 | ページタイトルはKubernetes Cluster | E-02 (行3) | ○ |
| C-24 | パンくずの設定 | E-02 (行1-2) | ○ |
| C-25 | 成功メッセージの表示 | E-01 (行58, 95) | ○ |
| C-26 | エラーメッセージの表示 | E-01 (行109) | ○ |
| C-27 | プロバイダー作成中の変更禁止 | E-03 (行375-380) | ○ |
| C-28 | 移行Issue更新機能 | E-01 (行115-133) | ○ |
| C-29 | パーシャルテンプレートの詳細 | **根拠なし** | △ |
| C-30 | EE機能（Environments）の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 各タブのパーシャルテンプレート
  - 候補：`_migrate_tab.html.haml` / `_details_tab.html.haml` / `_advanced_settings_tab.html.haml`
- EE専用のEnvironmentsタブ実装
- ClusterSerializerの詳細実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー実装は十分な根拠あり
- 1: 中リスク - パーシャルテンプレートの詳細は別途確認が必要
- 0: 低リスク - モデル実装は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各タブの表示確認
- [ ] 設定更新フローの動作確認
- [ ] 移行機能の動作確認
- [ ] クラスター削除の動作確認
- [ ] キャッシュクリアの動作確認
- [ ] ポーリングによる状態更新の動作確認
