---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：309-エージェントダッシュボード一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/clusters/agents/dashboard_controller.rb` - コントローラー実装
- E-02: `app/views/clusters/agents/dashboard/index.html.haml` - ビューテンプレート
- E-03: `config/routes.rb` - ルーティング定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的はエージェント未選択状態表示 | E-02 (行4-5) | ○ |
| C-02 | URLパスは`/-/kubernetes` | E-03 (行148) | ○ |
| C-03 | indexアクションで一覧表示 | E-01 (行15) | ○ |
| C-04 | ページタイトルはKubernetes Dashboard | E-02 (行2) | ○ |
| C-05 | パンくずタイトルはKubernetes Dashboard | E-02 (行1) | ○ |
| C-06 | 空状態コンポーネント使用 | E-02 (行4-9) | ○ |
| C-07 | タイトル「No agent selected」 | E-02 (行5) | ○ |
| C-08 | 説明文「select an agent from a project's environment page」 | E-02 (行12) | ○ |
| C-09 | 主ボタン「View projects」 | E-02 (行6) | ○ |
| C-10 | 副ボタン「Learn more」 | E-02 (行8) | ○ |
| C-11 | 主ボタン遷移先はdashboard_projects_path | E-02 (行7) | ○ |
| C-12 | 副ボタン遷移先はkubernetes_dashboard.mdヘルプ | E-02 (行9) | ○ |
| C-13 | k8s_dashboardフィーチャーフラグで制御 | E-01 (行8, 25-27) | ○ |
| C-14 | フラグ無効時は404 | E-01 (行26) | ○ |
| C-15 | feature_categoryはdeployment_management | E-01 (行13) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな空状態画面であり、すべての実装が確認できる
- 0: 低リスク - フィーチャーフラグ制御も明確

## 6) レビュアーチェックリスト（最小）
- [ ] k8s_dashboardフィーチャーフラグ有効時の表示確認
- [ ] フィーチャーフラグ無効時の404確認
- [ ] 「View projects」ボタンの遷移先確認
- [ ] 「Learn more」ボタンのヘルプドキュメント確認
- [ ] レスポンシブデザインの確認
