---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-ファイル表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **C-24**: LFSファイル表示の詳細動作
  2. **C-25**: Monaco Editorプリロードの具体的タイミング

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/blob/show.html.haml` - メインビューテンプレート
- E-02: `app/controllers/projects/blob_controller.rb` - Blobコントローラー
- E-03: `config/routes/repository.rb` - ルーティング定義
- E-04: `app/views/projects/blob/_blob.html.haml` - Blobパーシャル（参照）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名「ファイル表示」 | E-05 | ○ |
| C-02 | テンプレートパス `app/views/projects/blob/show.html.haml` | E-01 | ○ |
| C-03 | URL形式 `/{namespace}/{project}/-/blob/{ref}/{*path}` | E-03 (76-79行目) | ○ |
| C-04 | showアクションの存在 | E-02 (71-85行目) | ○ |
| C-05 | before_actionによる認証・認可チェック | E-02 (19-35行目) | ○ |
| C-06 | HTML/JSONレスポンス対応 | E-02 (74-84行目) | ○ |
| C-07 | ファイル編集への遷移 | E-02 (edit アクション) | ○ |
| C-08 | MAX_EDIT_SIZE = 10MB | E-02 (17行目) | ○ |
| C-09 | Rawダウンロード機能 | E-03 (87行目) | ○ |
| C-10 | Blame表示への遷移 | E-03 (90行目) | ○ |
| C-11 | コミット履歴への遷移 | E-03 (99行目) | ○ |
| C-12 | Web IDE連携 | E-01 (24行目) `render 'shared/web_ide_path'` | ○ |
| C-13 | GraphQLクエリ使用 | E-01 (7行目) `add_page_startup_graphql_call` | ○ |
| C-14 | Monaco Editorのプリロード | E-01 (6行目) `webpack_preload_asset_tag('monaco')` | ○ |
| C-15 | 主機能：ファイル閲覧(15) | E-06 | ○ |
| C-16 | 補助機能：Blame表示(23) | E-06 | ○ |
| C-17 | require_non_empty_project | E-02 (23行目) | ○ |
| C-18 | authorize_read_code | E-02 (25行目) | ○ |
| C-19 | ディレクトリの場合のリダイレクト | E-02 (196-201行目) | ○ |
| C-20 | バイナリファイルのBlame不可 | `app/controllers/projects/blame_controller.rb` (49-53行目) | ○ |
| C-21 | 最終コミット情報の取得 | E-02 (307行目) | ○ |
| C-22 | 環境情報の取得 | E-02 (300-306行目) | ○ |
| C-23 | コードナビゲーションパス | E-02 (308行目) | ○ |
| C-24 | LFSファイルの実内容表示 | **根拠不足** | △ |
| C-25 | Monaco Editorプリロード詳細動作 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: LFSファイル表示の詳細動作
  - 候補：`app/models/lfs_object.rb` / `lib/gitlab/lfs/` / LFS関連ドキュメント
- C-25: Monaco Editorプリロードの詳細動作
  - 候補：`app/assets/javascripts/` / Webpack設定 / フロントエンドドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造と処理フローは正確
- 1: 中リスク - LFS関連の詳細動作について要確認
- 0: 低リスク - フロントエンド詳細は別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] URLルーティングが実際のシステムと一致するか確認
- [ ] 権限チェックのbefore_actionが網羅されているか確認
- [ ] LFSファイル表示の実装詳細を確認（必要に応じて）
- [ ] Monaco Editorのプリロードタイミングを確認（必要に応じて）
