---
generated_at: 2026-01-22 11:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：310-エージェントダッシュボード詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsフロントエンドの詳細実装**：フロントエンドコードが未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/clusters/agents/dashboard_controller.rb` - コントローラー実装
- E-02: `app/views/clusters/agents/dashboard/show.html.haml` - ビューテンプレート
- E-03: `app/controllers/concerns/kas_cookie.rb` - KASクッキー処理
- E-04: `app/models/clusters/agent.rb` - エージェントモデル
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面の目的はKubernetesダッシュボード表示 | E-02 (行1-3) | ○ |
| C-02 | URLパスは`/-/kubernetes/:agent_id` | E-05 (行149) | ○ |
| C-03 | Vue Routerサブパス対応（*vueroute） | E-05 (行149) | ○ |
| C-04 | showアクションで詳細表示 | E-01 (行17) | ○ |
| C-05 | ページタイトルはDashboard | E-02 (行3) | ○ |
| C-06 | 親パンくずはKubernetes Dashboard | E-02 (行2) | ○ |
| C-07 | パンくずリンクはkubernetes_dashboard_path | E-02 (行2) | ○ |
| C-08 | check_feature_flag!でフラグ確認 | E-01 (行8, 25-27) | ○ |
| C-09 | find_agentでエージェント取得 | E-01 (行9, 21-23) | ○ |
| C-10 | authorize_read_cluster_agent!で権限確認 | E-01 (行10, 29-31) | ○ |
| C-11 | set_kas_cookieでクッキー設定 | E-01 (行11), E-03 (行18-27) | ○ |
| C-12 | current_user条件付きbefore_action | E-01 (行9-11) | ○ |
| C-13 | Vue.jsマウントポイント(.js-kubernetes-app) | E-02 (行5) | ○ |
| C-14 | data-base-path属性 | E-02 (行5) | ○ |
| C-15 | data-agent属性（@agent.to_json） | E-02 (行5) | ○ |
| C-16 | data-kas-tunnel-url属性 | E-02 (行5) | ○ |
| C-17 | Gitlab::Kas.tunnel_url使用 | E-02 (行5), E-03 (行31-33) | ○ |
| C-18 | KasCookieモジュールinclude | E-01 (行6) | ○ |
| C-19 | CSP設定でKAS URLを許可 | E-03 (行6-16) | ○ |
| C-20 | feature_categoryはdeployment_management | E-01 (行13) | ○ |
| C-21 | ローディングアイコン表示 | E-02 (行6) | ○ |
| C-22 | Vue.jsフロントエンドの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネント（`app/assets/javascripts/kubernetes_dashboard/`配下）の詳細実装
  - 候補：`kubernetes_dashboard_bundle.js` / 関連コンポーネント
- KASトンネル経由の通信処理詳細
- Kubernetesリソース表示コンポーネント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド実装は十分な根拠あり
- 1: 中リスク - フロントエンド実装の詳細は別途確認が必要
- 0: 低リスク - 認証・認可フローは明確

## 6) レビュアーチェックリスト（最小）
- [ ] k8s_dashboardフィーチャーフラグ有効時の表示確認
- [ ] フィーチャーフラグ無効時の404確認
- [ ] エージェント未存在時の404確認
- [ ] 権限なし時の404確認
- [ ] KASクッキー設定の動作確認
- [ ] Vue.jsアプリケーションの正常マウント確認
- [ ] Vue Router内遷移の動作確認
- [ ] KAS経由のKubernetes API通信確認
