---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：311-タイムログ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ダッシュボードからのアクセス方法**：メインナビゲーションの具体的な配置が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/time_tracking/timelogs_controller.rb`
- E-02: `app/views/time_tracking/timelogs/index.html.haml`
- E-03: `app/models/timelog.rb`
- E-04: `app/assets/javascripts/time_tracking/components/timelogs_app.vue`
- E-05: `config/routes.rb` (261行目)
- E-06: `画面機能マッピング.csv` (372行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/timelogs` である | E-05 | ○ |
| C-02 | コントローラは `TimeTracking::TimelogsController#index` | E-01 | ○ |
| C-03 | フィーチャーフラグ `global_time_tracking_report` で制御 | E-01 (9行目) | ○ |
| C-04 | Vueコンポーネント `timelogs_app.vue` を使用 | E-02, E-04 | ○ |
| C-05 | グループフィルタでReporter以上のアクセス権限 | E-04 (30-32行目) | ○ |
| C-06 | デフォルトで30日間のデータを表示 | E-04 (28行目) | ○ |
| C-07 | 1ページあたり20件表示 | E-04 (21行目) | ○ |
| C-08 | GraphQL APIでデータ取得 | E-04 (79-98行目) | ○ |
| C-09 | URLパラメータにフィルタ条件が保存される | E-04 (152-188行目) | ○ |
| C-10 | Timelogモデルはissueまたはmerge_requestに紐付く | E-03 (20-21行目) | ○ |
| C-11 | `time_tracking_limit_to_hours` 設定で表示形式が変わる | E-02 (7行目), E-04 (106-108行目) | ○ |
| C-12 | 合計時間を表示 | E-04 (88, 322-323行目) | ○ |
| C-13 | キーセットページネーションを使用 | E-04 (328-334行目) | ○ |
| C-14 | エラー時にアラートを表示 | E-04 (93-96行目) | ○ |
| C-15 | 関連機能はタイムトラッキング（機能No.43） | E-06 | ○ |
| C-16 | フィーチャーフラグ無効時は404を返す | E-01 (9行目) | ○ |
| C-17 | ダッシュボードからアクセス可能 | **根拠なし** | △ |
| C-18 | Sentryにエラーを送信 | E-04 (95行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- ダッシュボードからのアクセス経路
  - 候補：ナビゲーション設定ファイル / サイドバー定義ファイル / メニュー構成ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] ダッシュボードからのアクセス方法を確認（メニュー/サイドバーの設定確認）
- [ ] フィーチャーフラグが本番環境で有効かどうか確認
- [ ] GraphQL スキーマとクエリの整合性を確認
