---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：312-Jira接続状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/jira_connect/subscriptions_controller.rb`
- E-02: `app/views/jira_connect/subscriptions/index.html.haml`
- E-03: `app/models/jira_connect_subscription.rb`
- E-04: `app/models/jira_connect_installation.rb`
- E-05: `app/assets/javascripts/jira_connect/subscriptions/components/app.vue`
- E-06: `config/routes/jira_connect.rb`
- E-07: `画面機能マッピング.csv` (373行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/jira_connect/subscriptions` である | E-06 (14行目) | ○ |
| C-02 | コントローラは `JiraConnect::SubscriptionsController` | E-01 | ○ |
| C-03 | Jiraのiframe内で表示される | E-01 (4行目, 90-92行目) | ○ |
| C-04 | *.atlassian.net と *.jira.com からのiframe埋め込み許可 | E-01 (4行目) | ○ |
| C-05 | OAuth認証を使用してサインイン | E-05 (85-93行目) | ○ |
| C-06 | サブスクリプション作成時にCreateServiceを使用 | E-01 (75-81行目) | ○ |
| C-07 | サブスクリプション削除時にDestroyServiceを使用 | E-01 (84-87行目) | ○ |
| C-08 | JiraConnectSubscriptionはinstallationとnamespaceに紐付く | E-03 (4-5行目) | ○ |
| C-09 | namespaceの一意性制約がある | E-03 (8行目) | ○ |
| C-10 | JWT検証が行われる | E-01 (31行目) | ○ |
| C-11 | HTMLとJSONの両方のフォーマットに対応 | E-01 (38-43行目) | ○ |
| C-12 | サインイン状態によって表示が切り替わる | E-05 (45-47行目, 133-140行目) | ○ |
| C-13 | ブラウザサポートチェックを行う | E-05 (52-54行目) | ○ |
| C-14 | セルフマネージド連携時にCSP設定を追加 | E-01 (68-73行目) | ○ |
| C-15 | 関連機能はJira連携（機能No.96） | E-07 | ○ |
| C-16 | jira_connect レイアウトを使用 | E-01 (5行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] Jira Cloud環境での実際の動作確認
- [ ] OAuth認証フローの完全性確認
- [ ] CSP設定が適切にiframe埋め込みを許可していることを確認
