---
generated_at: 2026-01-22 12:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：313-Jiraブランチ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/jira_connect/branches_controller.rb`
- E-02: `app/views/jira_connect/branches/new.html.haml`
- E-03: `app/assets/javascripts/jira_connect/branches/pages/index.vue`
- E-04: `config/routes/jira_connect.rb`
- E-05: `画面機能マッピング.csv` (374-375行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/jira_connect/branches/new` である | E-04 (15行目) | ○ |
| C-02 | routeアクションでセルフマネージドへリダイレクト | E-01 (13-21行目), E-04 (16-18行目) | ○ |
| C-03 | コントローラは `JiraConnect::BranchesController` | E-01 | ○ |
| C-04 | ログインが必須（authenticate_user!） | E-01 (4行目) | ○ |
| C-05 | JWT検証はスキップ（newアクションのみ） | E-01 (5行目) | ○ |
| C-06 | Issue.to_branch_nameでブランチ名を生成 | E-01 (28-31行目) | ○ |
| C-07 | issue_keyとissue_summaryをパラメータで受け取る | E-01 (26-30行目) | ○ |
| C-08 | success_state_svg_pathを含むデータを渡す | E-01 (37-38行目) | ○ |
| C-09 | initial_branch_nameを含むデータを渡す | E-01 (36行目) | ○ |
| C-10 | 成功時にEmptyStateを表示 | E-03 (54-60行目) | ○ |
| C-11 | ページタイトルにイシューキーを含む | E-03 (26-30行目) | ○ |
| C-12 | 関連機能はJira連携（機能No.96）とブランチ管理（機能No.19） | E-05 | ○ |
| C-13 | hide_top_linksとcontent_classを設定 | E-02 (1-2行目) | ○ |
| C-14 | proxyの場合はinstance_urlへリダイレクト | E-01 (14-16行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] Jira Cloud環境での実際のブランチ作成テスト
- [ ] セルフマネージドインスタンスへのリダイレクト動作確認
- [ ] Issue.to_branch_nameメソッドの命名規則確認
