---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：315-ヘルプトップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/help_controller.rb`
- E-02: `app/views/help/index.html.haml`
- E-03: `config/routes/help.rb`
- E-04: `画面機能マッピング.csv` (377行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/help` である | E-03 (3行目) | ○ |
| C-02 | コントローラは `HelpController#index` | E-01, E-03 | ○ |
| C-03 | パブリック可視性制限がない場合は認証スキップ | E-01 (4行目) | ○ |
| C-04 | helpレイアウトを使用 | E-01 (8行目) | ○ |
| C-05 | doc/index.mdからドキュメントインデックスを読み込む | E-01 (15行目) | ○ |
| C-06 | Markdownリンクを/help/プレフィックス付きに変換 | E-01 (20-22行目) | ○ |
| C-07 | カスタムヘルプテキストを表示（設定がある場合） | E-02 (2-5行目) | ○ |
| C-08 | ログイン時のみバージョン情報を表示 | E-02 (9-10行目) | ○ |
| C-09 | バージョンチェックバッジを表示 | E-02 (11-12行目) | ○ |
| C-10 | 商用コンテンツ非表示設定で一部を非表示 | E-02 (14, 48-50行目) | ○ |
| C-11 | インスタンス設定リンクを表示 | E-02 (29行目) | ○ |
| C-12 | js-trigger-search-barでサーチバーを起動 | E-02 (43-44行目) | ○ |
| C-13 | js-trigger-shortcutでショートカットを表示 | E-02 (46-47行目) | ○ |
| C-14 | 関連機能はヘルプシステム（機能No.142） | E-04 | ○ |
| C-15 | Markdown内のリンクにhelp/プレフィックスを追加 | E-01 (20-22行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] doc/index.mdファイルの存在確認
- [ ] カスタムヘルプテキスト設定時の表示確認
- [ ] 商用コンテンツ非表示設定時の表示確認
