---
generated_at: 2026-01-22 12:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：316-ヘルプ記事

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/help_controller.rb`
- E-02: `app/views/help/show.html.haml`
- E-03: `config/routes/help.rb`
- E-04: `画面機能マッピング.csv` (378行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/help/*path` である | E-03 (8行目) | ○ |
| C-02 | コントローラは `HelpController#show` | E-01, E-03 | ○ |
| C-03 | パスのサニタイズを行う（Rack::Utils.clean_path_info） | E-01 (26行目) | ○ |
| C-04 | markdown, md, html フォーマットに対応 | E-01 (29行目) | ○ |
| C-05 | png, gif, jpeg, mp4, mp3 メディアに対応 | E-01 (38行目) | ○ |
| C-06 | メディアファイルはsend_fileで配信 | E-01 (43行目) | ○ |
| C-07 | ファイル不在時は404を返す | E-01 (45, 50行目) | ○ |
| C-08 | 外部ドキュメントサイトへリダイレクト可能 | E-01 (30-32行目) | ○ |
| C-09 | YAMLフロントマターを除去 | E-01 (12行目, 79-90行目) | ○ |
| C-10 | パスからページタイトルを生成 | E-02 (1行目) | ○ |
| C-11 | 流体レイアウトでない場合にコンテンツ幅を制限 | E-02 (2行目) | ○ |
| C-12 | Markdown本文をレンダリング | E-02 (4-5行目) | ○ |
| C-13 | 関連機能はヘルプシステム（機能No.142） | E-04 | ○ |
| C-14 | HugoTransformerでMarkdownを変換 | E-01 (157行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] 各種ドキュメントフォーマットの表示確認
- [ ] メディアファイル配信の動作確認
- [ ] 外部ドキュメントサイトへのリダイレクト設定時の動作確認
