---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：317-インスタンス設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/help_controller.rb`
- E-02: `app/views/help/instance_configuration.html.haml`
- E-03: `config/routes/help.rb`
- E-04: `画面機能マッピング.csv` (379行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/help/instance_configuration` である | E-03 (5行目) | ○ |
| C-02 | コントローラは `HelpController#instance_configuration` | E-01 (60-62行目), E-03 | ○ |
| C-03 | InstanceConfigurationオブジェクトを生成 | E-01 (61行目) | ○ |
| C-04 | ページタイトルは「Instance Configuration」 | E-02 (1行目) | ○ |
| C-05 | SSH設定パーシャルをレンダリング | E-02 (8行目) | ○ |
| C-06 | GitLab Pagesパーシャルをレンダリング | E-02 (9行目) | ○ |
| C-07 | サイズ制限パーシャルをレンダリング | E-02 (10行目) | ○ |
| C-08 | パッケージレジストリパーシャルをレンダリング | E-02 (11行目) | ○ |
| C-09 | レート制限パーシャルをレンダリング | E-02 (12行目) | ○ |
| C-10 | CI/CD制限パーシャルをレンダリング | E-02 (13行目) | ○ |
| C-11 | AI Gatewayは render_if_exists で EE版のみ | E-02 (14行目) | ○ |
| C-12 | 関連機能はアプリケーション設定（機能No.114） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] 各設定セクションの表示内容確認
- [ ] EE版でのAI Gateway表示確認
- [ ] 目次（Table of Contents）の動的生成確認
