---
generated_at: 2026-01-22 12:50:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：318-ドロワー表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/help_controller.rb`
- E-02: `app/views/help/drawers.html.haml`
- E-03: `config/routes/help.rb`
- E-04: `画面機能マッピング.csv` (380行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/help/drawers/*markdown_file` である | E-03 (6行目) | ○ |
| C-02 | コントローラは `HelpController#drawers` | E-01 (64-72行目), E-03 | ○ |
| C-03 | パスのサニタイズを行う（Rack::Utils.clean_path_info） | E-01 (65行目) | ○ |
| C-04 | path_to_docでフルパスを生成 | E-01 (66行目) | ○ |
| C-05 | ファイル不在時は404を返す | E-01 (71行目) | ○ |
| C-06 | レイアウトなしでレンダリング | E-01 (69行目) | ○ |
| C-07 | HTMLフォーマットでレンダリング | E-01 (69行目) | ○ |
| C-08 | 1日間キャッシュ | E-02 (1行目) | ○ |
| C-09 | get_markdown_without_frontmatterでフロントマター除去 | E-02 (2行目) | ○ |
| C-10 | 関連機能はヘルプシステム（機能No.142） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] ドロワー表示の動作確認（JavaScript側の呼び出し確認）
- [ ] キャッシュ動作の確認
- [ ] 存在しないファイルへのアクセス時の404確認
