---
generated_at: 2026-01-22 13:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：320-アクセス拒否

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/errors/access_denied.html.haml`
- E-02: `画面機能マッピング.csv` (382行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | messageはlocal_assignsからフェッチ | E-01 (1行目) | ○ |
| C-02 | ページタイトルは「Access Denied」 | E-01 (2行目) | ○ |
| C-03 | error-containerクラスを使用 | E-01 (4行目) | ○ |
| C-04 | error-403-lg.svgイラストを表示 | E-01 (5行目) | ○ |
| C-05 | 見出しは「403: You do not have the permission to access this page」 | E-01 (7行目) | ○ |
| C-06 | カスタムメッセージがあれば表示 | E-01 (10-11行目) | ○ |
| C-07 | 「Please contact your GitLab administrator to get permission.」を表示 | E-01 (12行目) | ○ |
| C-08 | js-go-backクラスで戻るボタンを制御 | E-01 (13行目) | ○ |
| C-09 | hidden属性でJavaScript無効時に非表示 | E-01 (13行目) | ○ |
| C-10 | Pajamas::ButtonComponentを使用 | E-01 (14行目) | ○ |
| C-11 | errors/footerパーシャルをレンダリング | E-01 (16行目) | ○ |
| C-12 | 関連機能はヘルスチェック（機能No.143） | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] 403エラー発生時の画面表示確認
- [ ] カスタムメッセージ付きでの表示確認
- [ ] 「Go Back」ボタンの動作確認
- [ ] JavaScript無効時のボタン非表示確認
