---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：321-Not Found

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **エラーページ用CSS**：具体的なファイルパスが未確認
  2. **検索フォームの動作**：検索機能との連携詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/errors/not_found.html.haml` (1-16行目)
- E-02: `app/views/errors/_footer.html.haml` (1-13行目)
- E-03: `app/controllers/application_controller.rb` (88-91行目: rescue_from)
- E-04: `app/controllers/application_controller.rb` (259-266行目: render_404)
- E-05: `app/controllers/application_controller.rb` (228-246行目: access_denied!)
- E-06: `app/controllers/application_controller.rb` (141-143行目: not_found)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (321行目)
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` (322行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 404エラー画面は存在しないリソースにアクセスした際に表示される | E-03, E-04 | ○ |
| C-02 | error-404-lg.svgがエラーイラストとして使用される | E-01 (3行目) | ○ |
| C-03 | 「404: Page not found」がタイトルとして表示される | E-01 (5行目) | ○ |
| C-04 | 検索フォームが提供される | E-01 (10-14行目) | ○ |
| C-05 | 検索は/searchにGETリクエストで送信される | E-01 (10行目) | ○ |
| C-06 | フッターにホーム、認証、ヘルプへのリンクがある | E-02 | ○ |
| C-07 | ログイン中はサインアウトリンクが表示される | E-02 (6-9行目) | ○ |
| C-08 | 未ログイン時はサインインリンクが表示される | E-02 (10行目) | ○ |
| C-09 | errorsレイアウトが使用される | E-04 (261行目) | ○ |
| C-10 | HTTPステータス404が返される | E-04 (261行目) | ○ |
| C-11 | ActiveRecord::RecordNotFoundで404が表示される | E-03 | ○ |
| C-12 | access_denied!でstatus=:not_foundの場合404が表示される | E-05 (232-235行目) | ○ |
| C-13 | 機能No.143ヘルスチェックが主機能として関連 | E-07 | ○ |
| C-14 | テンプレートパスはapp/views/errors/not_found.html.haml | E-08 | ○ |
| C-15 | i18n対応でs_()関数が使用されている | E-01 (5-8行目) | ○ |
| C-16 | サインアウトはPOSTで実行される | E-02 (8行目) | ○ |
| C-17 | エラーページ用CSSファイルが存在する | **根拠なし** | △ |
| C-18 | 検索フォームのプレースホルダーテキスト | E-01 (12行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- エラーページ用のCSSファイルの具体的パスが未確認
  - 候補：`app/assets/stylesheets/pages/errors.scss` / `app/assets/stylesheets/errors.scss` / 共通CSSに含まれる可能性

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は静的なエラー表示画面であり、ロジックがシンプル

## 6) レビュアーチェックリスト（最小）
- [ ] 404画面が実際に存在しないURLでアクセスした際に正しく表示されるか確認
- [ ] 検索フォームの動作確認
- [ ] ログイン状態によるフッターの表示切り替え確認
- [ ] 多言語対応の確認（日本語等での表示）
