---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：322-サービス利用不可

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠があるため、特に優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/errors/service_unavailable.html.haml` (1-14行目)
- E-02: `app/views/errors/_footer.html.haml` (1-13行目)
- E-03: `app/controllers/application_controller.rb` (127-130行目: rescue_from ResourceExhaustedError)
- E-04: `app/controllers/application_controller.rb` (132-135行目: rescue_from Regexp::TimeoutError)
- E-05: `app/controllers/application_controller.rb` (268-273行目: render_503)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (322行目)
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` (323行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 503エラー画面はサービス利用不可時に表示される | E-03, E-04, E-05 | ○ |
| C-02 | error-503-lg.svgがエラーイラストとして使用される | E-01 (3行目) | ○ |
| C-03 | 「503: We're sorry, GitLab is currently unavailable」がタイトル | E-01 (5行目) | ○ |
| C-04 | 動的メッセージはmessage変数が存在する場合のみ表示 | E-01 (6-8行目) | ○ |
| C-05 | フッターにホーム、認証、ヘルプへのリンクがある | E-02 | ○ |
| C-06 | errorsレイアウトが使用される | E-05 (270行目) | ○ |
| C-07 | HTTPステータス503が返される | E-05 (270行目) | ○ |
| C-08 | ResourceExhaustedErrorで503が表示される | E-03 | ○ |
| C-09 | Regexp::TimeoutErrorで503ステータスが返される | E-04 | ○ |
| C-10 | 機能No.143ヘルスチェックが主機能として関連 | E-06 | ○ |
| C-11 | テンプレートパスはapp/views/errors/service_unavailable.html.haml | E-07 | ○ |
| C-12 | i18n対応でs_()関数が使用されている | E-01 (5,10,12行目) | ○ |
| C-13 | render_503はmessageをオプション引数として受け取る | E-05 (268行目) | ○ |
| C-14 | 検索フォームは表示されない | E-01 (全行確認) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は静的なエラー表示画面であり、ロジックがシンプル

## 6) レビュアーチェックリスト（最小）
- [ ] サービス障害シミュレーション時に503画面が正しく表示されるか確認
- [ ] 動的メッセージが渡された場合の表示確認
- [ ] ログイン状態によるフッターの表示切り替え確認
- [ ] 多言語対応の確認（日本語等での表示）
