---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：323-コンフリクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **Go BackボタンのJavaScript実装**：実際のJSファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/errors/request_conflict.html.haml` (1-17行目)
- E-02: `app/views/errors/_footer.html.haml` (1-13行目)
- E-03: `app/controllers/application_controller.rb` (275-283行目: render_409)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (323行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (324行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 409エラー画面は競合発生時に表示される | E-03 | ○ |
| C-02 | error-409-lg.svgがエラーイラストとして使用される | E-01 (5行目) | ○ |
| C-03 | 「409: There was a conflict with your request」がタイトル | E-01 (7行目) | ○ |
| C-04 | 動的メッセージはmessage変数が存在する場合のみ表示 | E-01 (8-10行目) | ○ |
| C-05 | local_assigns.fetchでmessageを取得 | E-01 (1行目) | ○ |
| C-06 | フッターにホーム、認証、ヘルプへのリンクがある | E-02 | ○ |
| C-07 | errorsレイアウトが使用される | E-03 (278行目) | ○ |
| C-08 | HTTPステータス409が返される | E-03 (278行目: :conflict) | ○ |
| C-09 | Go Backボタンはhidden: trueで初期非表示 | E-01 (13行目) | ○ |
| C-10 | Go Backボタンは.js-go-backクラスを持つ | E-01 (13行目) | ○ |
| C-11 | 機能No.143ヘルスチェックが主機能として関連 | E-04 | ○ |
| C-12 | テンプレートパスはapp/views/errors/request_conflict.html.haml | E-05 | ○ |
| C-13 | i18n対応でs_()関数が使用されている | E-01 (7,12行目) | ○ |
| C-14 | render_409はmessageをオプション引数として受け取る | E-03 (275行目) | ○ |
| C-15 | Go BackボタンのJavaScriptでブラウザ履歴を戻る | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Go Backボタンを制御するJavaScriptファイルの具体的な実装が未確認
  - 候補：`app/assets/javascripts/errors.js` / Webpack bundleに含まれる可能性

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は静的なエラー表示画面であり、ロジックがシンプル

## 6) レビュアーチェックリスト（最小）
- [ ] 競合エラーシミュレーション時に409画面が正しく表示されるか確認
- [ ] 動的メッセージが渡された場合の表示確認
- [ ] Go Backボタンの動作確認（JavaScriptで履歴を戻るか）
- [ ] ログイン状態によるフッターの表示切り替え確認
- [ ] 多言語対応の確認（日本語等での表示）
