---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：325-OmniauthError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **oauth_errorレイアウトの存在確認**：具体的なファイルパスが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/errors/omniauth_error.html.haml` (1-18行目)
- E-02: `app/controllers/omniauth_callbacks_controller.rb` (343-350行目: fail_login)
- E-03: `app/controllers/omniauth_callbacks_controller.rb` (346行目: @provider設定)
- E-04: `app/controllers/omniauth_callbacks_controller.rb` (347行目: @error設定)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (325行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (326行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OAuth認証失敗時にこの画面が表示される | E-02 | ○ |
| C-02 | error-422-lg.svgがエラーイラストとして使用される | E-01 (4行目) | ○ |
| C-03 | 「422: Sign-in using {provider} auth failed」がタイトル | E-01 (6行目) | ○ |
| C-04 | @providerでプロバイダ名が動的に表示される | E-01 (6行目), E-03 | ○ |
| C-05 | @errorでエラー詳細が表示される | E-01 (8行目), E-04 | ○ |
| C-06 | Sign inボタンでログイン画面へ遷移 | E-01 (12-14行目) | ○ |
| C-07 | Recover passwordボタンでパスワードリカバリーへ遷移 | E-01 (16-17行目) | ○ |
| C-08 | Sign inボタンはconfirmバリアント | E-01 (12行目) | ○ |
| C-09 | oauth_errorレイアウトが使用される | E-02 (349行目) | ○ |
| C-10 | HTTPステータス422が返される | E-02 (349行目: :unprocessable_entity) | ○ |
| C-11 | fail_loginメソッドで呼び出される | E-02 | ○ |
| C-12 | @providerはProvider.label_forで取得 | E-03 | ○ |
| C-13 | @errorはuser.errors.full_messages.to_sentenceで取得 | E-04 | ○ |
| C-14 | 機能No.89 OAuth2クライアントが主機能として関連 | E-05 | ○ |
| C-15 | テンプレートパスはapp/views/errors/omniauth_error.html.haml | E-06 | ○ |
| C-16 | oauth_errorレイアウトファイルの存在 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- oauth_errorレイアウトファイルの具体的なパスが未確認
  - 候補：`app/views/layouts/oauth_error.html.haml` / `app/views/layouts/oauth_error.html.erb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は認証エラー時の静的なエラー表示画面

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth認証失敗時にOmniAuthError画面が正しく表示されるか確認
- [ ] プロバイダ名が正しく表示されるか確認（GitHub、Google等）
- [ ] エラーメッセージが適切に表示されるか確認
- [ ] Sign inボタンの遷移先確認
- [ ] Recover passwordボタンの遷移先確認
- [ ] 多言語対応の確認（日本語等での表示）
