---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：326-エンコーディングエラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠があるため、特に優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/errors/encoding.html.haml` (1-9行目)
- E-02: `app/controllers/application_controller.rb` (83-86行目: rescue_from Encoding::CompatibilityError)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (326行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (327行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Encoding::CompatibilityError発生時にこの画面が表示される | E-02 | ○ |
| C-02 | error-500-lg.svgがエラーイラストとして使用される | E-01 (4行目) | ○ |
| C-03 | 「500: Encoding error」がタイトル | E-01 (6行目) | ○ |
| C-04 | エンコーディングエラーについてのメッセージが表示される | E-01 (8行目) | ○ |
| C-05 | フッターが表示されない | E-01 (全行確認、footerなし) | ○ |
| C-06 | errorsレイアウトが使用される | E-02 (85行目) | ○ |
| C-07 | HTTPステータス500が返される | E-02 (85行目: :internal_server_error) | ○ |
| C-08 | log_exceptionで例外がログに記録される | E-02 (84行目) | ○ |
| C-09 | 機能No.143ヘルスチェックが主機能として関連 | E-03 | ○ |
| C-10 | テンプレートパスはapp/views/errors/encoding.html.haml | E-04 | ○ |
| C-11 | i18n対応でs_()関数が使用されている | E-01 (6,8行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は静的なエラー表示画面であり、ロジックが非常にシンプル

## 6) レビュアーチェックリスト（最小）
- [ ] エンコーディングエラー発生時にこの画面が正しく表示されるか確認
- [ ] ページタイトルの確認（「Encoding Error」）
- [ ] HTTPステータス500が返されるか確認
- [ ] 多言語対応の確認（日本語等での表示）
