---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：327-事前条件失敗

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **エントリーポイントの確認**：この画面を呼び出すコントローラロジックが未確認
  2. **ページタイトルの誤り**：「Encoding Error」となっているが412エラー画面のため不整合

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/errors/precondition_failed.html.haml` (1-9行目)
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (327行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (328行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 事前条件失敗時にこの画面が表示される | E-01 | ○ |
| C-02 | error-422-lg.svgがエラーイラストとして使用される | E-01 (4行目) | ○ |
| C-03 | 「412: Precondition failed」がタイトル | E-01 (6行目) | ○ |
| C-04 | 無効なパラメータについてのメッセージが表示される | E-01 (8行目) | ○ |
| C-05 | フッターが表示されない | E-01 (全行確認、footerなし) | ○ |
| C-06 | HTTPステータス412が返される | **根拠なし** | △ |
| C-07 | errorsレイアウトが使用される | **根拠なし** | △ |
| C-08 | 機能No.143ヘルスチェックが主機能として関連 | E-02 | ○ |
| C-09 | テンプレートパスはapp/views/errors/precondition_failed.html.haml | E-03 | ○ |
| C-10 | i18n対応でs_()関数が使用されている | E-01 (6,8行目) | ○ |
| C-11 | altテキストが「412」になっている | E-01 (4行目) | ○ |
| C-12 | ページタイトルが「Encoding Error」になっている（不整合） | E-01 (1行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- この画面を呼び出すコントローラのコード（render_412メソッドやrescue_from等）が未確認
  - ApplicationControllerでの標準的なメソッドは見つからなかった
- errorsレイアウトの使用確認が取れていない（テンプレート呼び出し元のコードが未確認）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ページタイトルが「Encoding Error」となっており、内容と不整合。テンプレート作成時のコピーミスの可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ページタイトル「Encoding Error」の修正検討（「Precondition Failed」が適切）
- [ ] この画面を呼び出すコントローラのコードを確認
- [ ] 実際に412エラーが発生した時にこの画面が表示されるか確認
- [ ] 多言語対応の確認（日本語等での表示）
