---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：328-通知期限切れ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠があるため、特に優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/errors/expired_sent_notification.html.haml` (1-16行目)
- E-02: `app/views/errors/_footer.html.haml` (1-13行目)
- E-03: `app/controllers/sent_notifications_controller.rb` (16-22行目: unsubscribe)
- E-04: `app/controllers/sent_notifications_controller.rb` (38-42行目: unsubscribe_prerequisites_met?)
- E-05: `app/controllers/sent_notifications_controller.rb` (93-95行目: render_expired_link)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (328行目)
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` (329行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 期限切れリンクアクセス時にこの画面が表示される | E-03, E-05 | ○ |
| C-02 | status-fail-md.svgがエラーイラストとして使用される | E-01 (3行目) | ○ |
| C-03 | 「Expired link」がタイトル | E-01 (5行目) | ○ |
| C-04 | 「This link is no longer valid.」がメッセージ | E-01 (7行目) | ○ |
| C-05 | 直接リンクを使用する案内が表示される | E-01 (8行目) | ○ |
| C-06 | 検索フォームが提供される | E-01 (10-14行目) | ○ |
| C-07 | フッターにホーム、認証、ヘルプへのリンクがある | E-02 | ○ |
| C-08 | errorsレイアウトが使用される | E-05 (94行目) | ○ |
| C-09 | HTTPステータス404が返される | E-05 (94行目: :not_found) | ○ |
| C-10 | render_expired_linkメソッドで呼び出される | E-05 | ○ |
| C-11 | unsubscribe_prerequisites_met?がfalseの場合に表示 | E-03 (17行目), E-04 | ○ |
| C-12 | sent_notification、unsubscribable?、noteableがチェックされる | E-04 | ○ |
| C-13 | 機能No.137メール通知が主機能として関連 | E-06 | ○ |
| C-14 | テンプレートパスはapp/views/errors/expired_sent_notification.html.haml | E-07 | ○ |
| C-15 | i18n対応でs_()関数が使用されている | E-01 (1,5,7,8行目) | ○ |
| C-16 | 検索フォームのプレースホルダー確認 | E-01 (12行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面は期限切れリンク用の静的なエラー表示画面

## 6) レビュアーチェックリスト（最小）
- [ ] 期限切れの購読解除リンクにアクセスした時にこの画面が表示されるか確認
- [ ] 検索フォームの動作確認
- [ ] ログイン状態によるフッターの表示切り替え確認
- [ ] 多言語対応の確認（日本語等での表示）
