---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：329-不正利用報告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠があるため、特に優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/abuse_reports/new.html.haml` (1-47行目)
- E-02: `app/controllers/abuse_reports_controller.rb` (1-68行目)
- E-03: `app/models/abuse_report.rb` (1-284行目)
- E-04: `app/services/anti_abuse/abuse_report/create_service.rb` (1-40行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (329行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (330行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カテゴリは読み取り専用で表示される | E-01 (15-16行目: readonly: true) | ○ |
| C-02 | ユーザー名は読み取り専用で表示される | E-01 (19-21行目: readonly: true) | ○ |
| C-03 | 報告元URLは読み取り専用で表示される | E-01 (24-25行目: readonly: true) | ○ |
| C-04 | スクリーンショットは1MB以下に制限 | E-03 (71行目: MAX_FILE_SIZE) | ○ |
| C-05 | メッセージは必須入力 | E-01 (38行目: required: true), E-03 (38行目) | ○ |
| C-06 | user_idは隠しフィールド | E-01 (11行目: hidden_field) | ○ |
| C-07 | CreateServiceで報告が作成される | E-02 (26行目) | ○ |
| C-08 | 成功時にnotifyが呼ばれる | E-02 (31行目) | ○ |
| C-09 | Gitlab::Trackingでイベントが記録される | E-02 (15-20行目, 33-38行目) | ○ |
| C-10 | 成功時はルートパスへリダイレクト | E-02 (41行目) | ○ |
| C-11 | 削除済みユーザーはルートパスへリダイレクト | E-02 (62行目) | ○ |
| C-12 | BAN済みユーザーはユーザーページへリダイレクト | E-02 (64行目) | ○ |
| C-13 | カテゴリの種類（enum） | E-03 (79-88行目) | ○ |
| C-14 | 同じユーザー・カテゴリの重複報告は禁止 | E-03 (40-46行目) | ○ |
| C-15 | リンクは最大20件まで | E-03 (57-62行目) | ○ |
| C-16 | 報告元URLは512文字まで | E-03 (21,48-55行目) | ○ |
| C-17 | organization_idが設定される | E-04 (23行目) | ○ |
| C-18 | reporterのバリデーション | E-04 (29-32行目) | ○ |
| C-19 | js-quick-submitクラスが設定されている | E-01 (6行目) | ○ |
| C-20 | スパムリンクの表示コンポーネント | E-01 (26行目: #js-links-to-spam) | ○ |
| C-21 | 機能No.139監査イベントが主機能として関連 | E-05 | ○ |
| C-22 | テンプレートパスはapp/views/abuse_reports/new.html.haml | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 不正利用報告画面は標準的なフォーム画面

## 6) レビュアーチェックリスト（最小）
- [ ] 報告フォームの表示確認
- [ ] 各フィールドの読み取り専用属性確認
- [ ] スクリーンショットアップロード機能の動作確認（1MB制限）
- [ ] 報告送信時の成功・エラーメッセージ確認
- [ ] 削除済み・BAN済みユーザーへのアクセス時の動作確認
- [ ] 重複報告時のエラーメッセージ確認
- [ ] 多言語対応の確認（日本語等での表示）
