---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：330-アプリケーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠があるため、特に優先度の高いレビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/doorkeeper/applications/index.html.haml` (1-8行目)
- E-02: `app/views/shared/doorkeeper/applications/_index.html.haml` (1-99行目)
- E-03: `app/views/shared/doorkeeper/applications/_form.html.haml` (1-30行目)
- E-04: `app/views/shared/doorkeeper/applications/_delete_form.html.haml` (1-8行目)
- E-05: `app/controllers/oauth/applications_controller.rb` (1-100行目)
- E-06: `app/services/applications/create_service.rb` (1-41行目)
- E-07: `app/models/authn/oauth_application.rb` (1-33行目)
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (330行目)
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` (331行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルは「Applications」 | E-01 (1行目: page_title _("Applications")) | ○ |
| C-02 | profileレイアウトを使用 | E-05 (22行目: layout 'profile') | ○ |
| C-03 | ログイン必須（authenticate_user!） | E-05 (15行目: prepend_before_action :authenticate_user!) | ○ |
| C-04 | OAuthアプリ機能の有効/無効チェックが行われる | E-05 (14行目, 58-62行目: verify_user_oauth_applications_enabled) | ○ |
| C-05 | set_index_varsでアプリケーション一覧を取得 | E-05 (64-73行目) | ○ |
| C-06 | keyset paginateを使用 | E-05 (65行目: .keyset_paginate) | ○ |
| C-07 | Applications::CreateServiceでアプリ作成 | E-05 (31行目), E-06 | ○ |
| C-08 | スコープ未選択時にエラー | E-06 (27-31行目: Scopes can't be blank) | ○ |
| C-09 | 無効時は警告アラートを表示 | E-02 (58-60行目: AlertComponent, Adding new applications is disabled) | ○ |
| C-10 | Your applicationsセクションの表示 | E-02 (17-55行目: CrudComponent, 'Your applications') | ○ |
| C-11 | Authorized applicationsセクションの表示 | E-02 (62-98行目: CrudComponent, 'Authorized applications') | ○ |
| C-12 | アプリケーション一覧テーブルにName, Callback URL, Clientsカラム | E-02 (34-37行目) | ○ |
| C-13 | 編集ボタンにpencilアイコンを使用 | E-02 (50行目: icon: 'pencil') | ○ |
| C-14 | 削除時に確認ダイアログを表示 | E-04 (4,6行目: data: { confirm: _("Are you sure?") }) | ○ |
| C-15 | フォームにname, redirect_uri, confidential, scopesフィールド | E-03 (6-23行目) | ○ |
| C-16 | リダイレクトURIは複数行入力可能 | E-03 (12行目: text_area), E-03 (15行目: Use one line per URI) | ○ |
| C-17 | Confidentialチェックボックスの説明文 | E-03 (18-19行目) | ○ |
| C-18 | 認可済みアプリにName, Authorized At, Scopeカラム | E-02 (73-76行目) | ○ |
| C-19 | Anonymousアプリケーション表示（application nilの場合） | E-02 (84-86行目) | ○ |
| C-20 | latest_per_applicationで最新トークンのみ取得 | E-05 (68行目) | ○ |
| C-21 | アプリケーション未登録時のメッセージ | E-02 (53行目: "You don't have any applications.") | ○ |
| C-22 | 認可済みアプリなし時のメッセージ | E-02 (98行目: "You don't have any authorized applications.") | ○ |
| C-23 | RecordNotFound時に404を表示 | E-05 (80-82行目: rescue_from ActiveRecord::RecordNotFound) | ○ |
| C-24 | organization_idがパラメータに含まれる | E-05 (87行目: params[:organization] = Current.organization) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - OAuthアプリケーション管理画面はDoorkeeper gemの標準的な構成に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] アプリケーション一覧の表示確認
- [ ] 新規アプリケーション登録フォームの動作確認
- [ ] アプリケーション編集・削除の動作確認
- [ ] 認可済みアプリケーション一覧の表示確認
- [ ] 認可取消機能の動作確認
- [ ] OAuthアプリ機能が無効な場合の警告表示確認
- [ ] ページネーションの動作確認
- [ ] 多言語対応の確認（日本語等での表示）
