---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：331-OAuthアプリケーション詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **自動認可（skip_authorization）の動作条件**：根拠不足
  2. **カスケード削除の詳細動作**：根拠不足
  3. **Vue.jsコンポーネントの詳細実装**：コード未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/doorkeeper/applications/show.html.haml`
- E-02: `app/views/shared/doorkeeper/applications/_show.html.haml`
- E-03: `app/controllers/oauth/applications_controller.rb`
- E-04: `app/models/authn/oauth_application.rb`
- E-05: `config/initializers/doorkeeper.rb`
- E-06: `config/routes.rb`
- E-07: `app/views/shared/doorkeeper/applications/_form.html.haml`
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はOAuthアプリケーション詳細を表示する | E-01, E-02 | ○ |
| C-02 | URLパスは `/oauth/applications/:id` | E-06 | ○ |
| C-03 | Application IDをコピーできる | E-02 (行12: clipboard_button) | ○ |
| C-04 | シークレット再生成機能がある | E-03 (行44-53: renewアクション) | ○ |
| C-05 | コールバックURLが表示される | E-02 (行23-25) | ○ |
| C-06 | Confidential設定が表示される | E-02 (行37-38) | ○ |
| C-07 | スコープ一覧が表示される | E-02 (行40: render scopes_list) | ○ |
| C-08 | 編集ボタンで編集画面へ遷移 | E-02 (行47: link_button_to Edit) | ○ |
| C-09 | 削除機能がある | E-02 (行43: delete_form) | ○ |
| C-10 | ログインユーザーのみアクセス可能 | E-03 (行15: authenticate_user!) | ○ |
| C-11 | 所有者のみアプリケーション閲覧可能 | E-03 (行76-78: set_application) | ○ |
| C-12 | 機能有効チェックが行われる | E-03 (行14, 58-62) | ○ |
| C-13 | renewアクションはJSON返却 | E-03 (行50-52) | ○ |
| C-14 | RecordNotFoundで404返却 | E-03 (行80-82) | ○ |
| C-15 | アプリケーション作成直後にContinueボタン表示 | E-02 (行45-46: @created) | ○ |
| C-16 | シークレットは暗号化保存 | E-05 (Doorkeeper設定) | ○ |
| C-17 | レイアウトは'profile' | E-03 (行22) | ○ |
| C-18 | パンくずリストが設定される | E-01 (行1-2) | ○ |
| C-19 | ページタイトルにアプリ名が含まれる | E-01 (行3) | ○ |
| C-20 | Authn::OauthApplicationはDoorkeeper::Application継承 | E-04 (行4) | ○ |
| C-21 | organizationとの関連付けがある | E-04 (行7) | ○ |
| C-22 | secret_matches?メソッドで認証 | E-04 (行17-31) | ○ |
| C-23 | 自動認可はConfidentialアプリで有効 | **根拠なし** | △ |
| C-24 | 削除時に関連トークンもカスケード削除 | **根拠なし** | △ |
| C-25 | 関連機能No.88はOAuth2プロバイダ | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-23: 自動認可（skip_authorization）の詳細条件
  - 候補：Doorkeeper gem内部実装 / AuthorizationsController / アプリケーション設定
- C-24: カスケード削除の実装詳細
  - 候補：Doorkeeper::Application モデル / データベースのFOREIGN KEY制約 / dependent: :destroy設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張がソースコードで確認済み
- 1: 中リスク - シークレット再生成のセキュリティ面は追加レビュー推奨
- 0: 低リスク - 画面遷移は標準的なCRUD操作

## 6) レビュアーチェックリスト（最小）
- [ ] シークレット再生成時の確認ダイアログの実装確認（フロントエンド）
- [ ] 削除時のカスケード削除の動作確認
- [ ] 管理者用画面との表示差分の確認
- [ ] Vue.jsコンポーネント（js-oauth-application-secret）の実装確認
