---
generated_at: 2026-01-22 10:32:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：332-OAuthアプリケーション編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **スコープ変更の既存トークンへの影響**：根拠不足
  2. **URI形式バリデーションの詳細**：Doorkeeper gem内部
  3. **エラーメッセージの正確なID**：i18nファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/doorkeeper/applications/edit.html.haml`
- E-02: `app/views/shared/doorkeeper/applications/_form.html.haml`
- E-03: `app/controllers/oauth/applications_controller.rb`
- E-04: `config/initializers/doorkeeper.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はOAuthアプリケーション編集を行う | E-01 | ○ |
| C-02 | URLパスは `/oauth/applications/:id/edit` | E-03 (Doorkeeper規約) | ○ |
| C-03 | Name入力フィールドがある | E-02 (行6-8) | ○ |
| C-04 | Redirect URI入力がtextareaである | E-02 (行10-12) | ○ |
| C-05 | Confidentialチェックボックスがある | E-02 (行17-19) | ○ |
| C-06 | スコープ選択がある | E-02 (行21-23) | ○ |
| C-07 | 「Save application」ボタンがある | E-02 (行26) | ○ |
| C-08 | ページタイトルに「Edit」が含まれる | E-01 (行1) | ○ |
| C-09 | load_scopesがbefore_actionで呼ばれる | E-03 (行17) | ○ |
| C-10 | gitlab_ui_form_forが使用される | E-02 (行3) | ○ |
| C-11 | forbid_redirect_uriでスキーム制限 | E-04 (行83) | ○ |
| C-12 | data/vbscript/javascriptスキームが禁止 | E-04 (行83) | ○ |
| C-13 | ヘルプテキスト「Use one line per URI」 | E-02 (行14-15) | ○ |
| C-14 | Confidentialのヘルプテキストがある | E-02 (行18-19) | ○ |
| C-15 | form_errorsで検証エラー表示 | E-02 (行4) | ○ |
| C-16 | application_paramsでstrong parameters | E-03 (行84-89) | ○ |
| C-17 | ownerがcurrent_userに設定される | E-03 (行86) | ○ |
| C-18 | organizationがCurrent.organizationに設定 | E-03 (行87) | ○ |
| C-19 | OAuthアプリ機能無効時はリダイレクト | E-03 (行58-62) | ○ |
| C-20 | 所有者以外は404エラー | E-03 (行76-78, 80-82) | ○ |
| C-21 | _scopes_form partialが使用される | E-02 (行23) | ○ |
| C-22 | スコープ変更は既存トークンに影響しない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: スコープ変更の既存トークンへの影響
  - 候補：Doorkeeper gem のドキュメント / アクセストークン検証ロジック / OAuth仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構造はソースコードで確認済み
- 1: 中リスク - バリデーションエラーメッセージの正確なi18nキーは要確認
- 0: 低リスク - 基本的なCRUD編集画面

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションエラーメッセージの日本語化状況確認
- [ ] Redirect URIの複数行入力のUX確認
- [ ] スコープ変更時の既存トークンへの影響調査
- [ ] Confidential設定変更の影響範囲確認
